/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.model.format;

import ch.elexis.core.l10n.Messages;
import ch.elexis.core.model.IContact;
import ch.elexis.core.model.IOrganization;
import ch.elexis.core.model.IPerson;
import ch.elexis.core.model.format.PersonFormatUtil;
import ch.elexis.core.model.format.PostalAddress;
import ch.elexis.core.types.Country;
import ch.elexis.core.types.Gender;
import ch.rgw.tools.StringTool;
import ch.rgw.tools.TimeTool;
import java.time.LocalDateTime;
import org.apache.commons.lang3.StringUtils;

public class AddressFormatUtil {
    public static String getSingleLine(IPerson person) {
        String thisAddressEmail;
        String thisAddressFax;
        String thisAddressMobile;
        String thisAddressPhone2;
        String thisAddressPhone1;
        String thisAddressCity;
        String thisAddressZip;
        Country thisAddressCountry;
        String thisAddressStreet;
        LocalDateTime dateOfBirth;
        StringBuilder ret = new StringBuilder();
        ret.append(PersonFormatUtil.getSalutation(person));
        ret.append(" ");
        String titel = person.getTitel();
        if (!StringTool.isNothing((Object)titel)) {
            ret.append(titel).append(" ");
        }
        if (!StringTool.isNothing((Object)person.getLastName())) {
            ret.append(person.getLastName() + " ");
        }
        if (!StringTool.isNothing((Object)person.getFirstName())) {
            ret.append(person.getFirstName());
        }
        if ((dateOfBirth = person.getDateOfBirth()) != null) {
            ret.append(", " + new TimeTool(dateOfBirth).toString(4));
        }
        if (!StringTool.isNothing((Object)(thisAddressStreet = person.getStreet()))) {
            ret.append(", " + thisAddressStreet);
        }
        if ((thisAddressCountry = person.getCountry()) != null && thisAddressCountry != Country.NDF) {
            ret.append(", " + thisAddressCountry.name() + "-");
        }
        if (!StringTool.isNothing((Object)(thisAddressZip = person.getZip()))) {
            if (StringTool.isNothing((Object)((Object)thisAddressCountry))) {
                ret.append(", ");
            }
            ret.append(thisAddressZip);
        }
        if (!StringTool.isNothing((Object)(thisAddressCity = person.getCity()))) {
            if (StringTool.isNothing((Object)((Object)thisAddressCountry)) && StringTool.isNothing((Object)thisAddressZip)) {
                ret.append(",");
            }
            ret.append(" " + thisAddressCity);
        }
        if (!StringTool.isNothing((Object)(thisAddressPhone1 = person.getPhone1()))) {
            ret.append(",  " + thisAddressPhone1);
        }
        if (!StringTool.isNothing((Object)(thisAddressPhone2 = person.getPhone2()))) {
            ret.append(",  " + thisAddressPhone2);
        }
        if (!StringTool.isNothing((Object)(thisAddressMobile = person.getMobile()))) {
            ret.append(", " + Messages.Core_Mobilephone + " " + thisAddressMobile);
        }
        if (!StringTool.isNothing((Object)(thisAddressFax = person.getFax()))) {
            ret.append(", " + Messages.Core_Fax + " " + thisAddressFax);
        }
        if (!StringTool.isNothing((Object)(thisAddressEmail = person.getEmail()))) {
            ret.append(", " + thisAddressEmail);
        }
        return ret.toString();
    }

    public static String getFullnameWithSalutation(IContact contact) {
        StringBuilder sb = new StringBuilder();
        if (contact instanceof IPerson) {
            IPerson person = (IPerson)contact;
            String salutation = person.getGender() == Gender.MALE ? Messages.Contact_SalutationM : Messages.Contact_SalutationF;
            sb.append(salutation);
            sb.append("\n");
            if (StringUtils.isNotBlank((CharSequence)person.getTitel())) {
                sb.append(person.getTitel()).append(" ");
            }
            sb.append(person.getFirstName()).append(" ").append(person.getLastName()).append("\n");
        } else if (contact instanceof IOrganization) {
            IOrganization organization = (IOrganization)contact;
            sb.append(organization.getDescription1()).append(" ");
            if (StringUtils.isNotBlank((CharSequence)organization.getDescription2())) {
                sb.append(organization.getDescription2());
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    public static String createPostalAddress(IContact contact) {
        PostalAddress postalAddress = PostalAddress.of(contact);
        String ret = AddressFormatUtil.getFullnameWithSalutation(contact) + postalAddress.getWrittenAddress(false, true);
        if (StringUtils.isEmpty((CharSequence)contact.getPostalAddress())) {
            contact.setPostalAddress(ret);
        }
        return ret;
    }

    public static String getPostalAddress(IContact contact, boolean multiline) {
        String postalAddress = contact.getPostalAddress();
        if (StringTool.isNothing((Object)postalAddress)) {
            postalAddress = AddressFormatUtil.createPostalAddress(contact);
        }
        postalAddress = postalAddress.replaceAll("[\\r\\n]\\n", "\n");
        return multiline ? postalAddress : postalAddress.replaceAll("\\n", " ");
    }

    public static String getAddressPhoneFaxEmail(IContact contact, boolean multiline, boolean includePhone) {
        StringBuffer thisAddress = new StringBuffer();
        thisAddress.append(AddressFormatUtil.getPostalAddress(contact, true).trim());
        thisAddress.append(System.lineSeparator());
        if (includePhone) {
            if (StringUtils.isNotBlank((CharSequence)contact.getPhone1())) {
                thisAddress.append(contact.getPhone1() + System.lineSeparator());
            }
            if (StringUtils.isNotBlank((CharSequence)contact.getPhone2())) {
                thisAddress.append(contact.getPhone2() + System.lineSeparator());
            }
            if (StringUtils.isNotBlank((CharSequence)contact.getMobile())) {
                thisAddress.append(Messages.Core_Mobilephone + ": " + contact.getMobile() + System.lineSeparator());
            }
        }
        if (StringUtils.isNotBlank((CharSequence)contact.getFax())) {
            thisAddress.append(Messages.Core_Fax + ": " + contact.getFax() + System.lineSeparator());
        }
        if (StringUtils.isNotBlank((CharSequence)contact.getEmail())) {
            thisAddress.append(contact.getEmail() + System.lineSeparator());
        }
        String an = thisAddress.toString();
        an = an.replaceAll("[\\r\\n]\\n", "\n");
        return multiline ? an : an.replaceAll("\\n", " ");
    }
}

