/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.model.builder;

import ch.elexis.core.model.IContact;
import ch.elexis.core.model.IReminder;
import ch.elexis.core.model.builder.AbstractBuilder;
import ch.elexis.core.model.issue.ProcessStatus;
import ch.elexis.core.model.issue.Visibility;
import ch.elexis.core.services.IContextService;
import ch.elexis.core.services.IModelService;
import java.time.LocalDate;

public class IReminderBuilder
extends AbstractBuilder<IReminder> {
    public IReminderBuilder(IModelService modelService, IContextService context, Visibility visibility, ProcessStatus status, String message) {
        super(modelService);
        this.object = modelService.create(IReminder.class);
        ((IReminder)this.object).setStatus(status);
        ((IReminder)this.object).setDue(LocalDate.now());
        ((IReminder)this.object).setVisibility(visibility);
        ((IReminder)this.object).setMessage(message);
        if (context != null) {
            ((IReminder)this.object).setCreator(context.getActiveUserContact().orElse(null));
            ((IReminder)this.object).setContact(context.getActiveUserContact().orElse(null));
        }
    }

    public IReminderBuilder addResponsible(IContact responsible) {
        ((IReminder)this.object).addResponsible(responsible);
        return this;
    }

    public IReminderBuilder contact(IContact contact) {
        ((IReminder)this.object).setContact(contact);
        return this;
    }

    public IReminderBuilder subject(String subject) {
        ((IReminder)this.object).setSubject(subject);
        return this;
    }

    public IReminderBuilder visibility(Visibility visibility) {
        ((IReminder)this.object).setVisibility(visibility);
        return this;
    }

    public IReminderBuilder status(ProcessStatus status) {
        ((IReminder)this.object).setStatus(status);
        return this;
    }
}

