/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.model.agenda;

import ch.elexis.core.model.IAppointment;
import ch.elexis.core.model.IContact;
import ch.elexis.core.model.agenda.EndingType;
import ch.elexis.core.model.agenda.SeriesType;
import ch.elexis.core.services.IModelService;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecurringAppointment {
    public static Logger logger = LoggerFactory.getLogger(RecurringAppointment.class);
    private String groupId;
    private IAppointment rootTermin;
    private IContact contact;
    private String freeText;
    private String reason;
    private Date beginTime;
    private Date endTime;
    private Date seriesStartDate;
    private String seriesPatternString;
    private EndingType endingType;
    private String endingPatternString;
    private Date endsOnDate;
    private String endsAfterNDates;
    private SeriesType seriesType;

    public RecurringAppointment(IAppointment appointment, IModelService modelService) {
        this.groupId = appointment.getLinkgroup();
        this.rootTermin = modelService.load(this.groupId, IAppointment.class, true).orElseThrow(() -> new IllegalStateException("Not existing root appointment with id [" + this.groupId + "]"));
        if (this.rootTermin.isDeleted()) {
            this.setFreeText("");
            this.reason = "";
            this.beginTime = Date.from(LocalDate.EPOCH.atStartOfDay().atZone(ZoneId.systemDefault()).toInstant());
            this.endTime = Date.from(LocalDate.EPOCH.atStartOfDay().atZone(ZoneId.systemDefault()).toInstant());
            this.seriesStartDate = Date.from(LocalDate.EPOCH.atStartOfDay().atZone(ZoneId.systemDefault()).toInstant());
        } else {
            this.contact = this.rootTermin.getContact();
            if (this.contact == null) {
                this.setFreeText(this.rootTermin.getSubjectOrPatient());
            }
            this.reason = this.rootTermin.getReason();
            this.parseSerienTerminConfigurationString(this.rootTermin.getExtension());
        }
    }

    private void parseSerienTerminConfigurationString(String serienTerminConfigurationString) {
        String[] terms = serienTerminConfigurationString.split(";");
        String[] termin = terms[0].split(",");
        SimpleDateFormat timeDf = new SimpleDateFormat("HHmm");
        SimpleDateFormat dateDf = new SimpleDateFormat("ddMMyyyy");
        try {
            this.beginTime = timeDf.parse(termin[0]);
            this.endTime = timeDf.parse(termin[1]);
            this.seriesStartDate = dateDf.parse(terms[3]);
        }
        catch (Exception e) {
            logger.error("unexpected exception", (Throwable)e);
        }
        char seriesTypeCharacter = terms[1].toUpperCase().charAt(0);
        this.setSeriesType(SeriesType.getForCharacter(seriesTypeCharacter));
        this.seriesPatternString = terms[2];
        char endingTypeCharacter = terms[4].toUpperCase().charAt(0);
        this.endingType = EndingType.getForCharacter(endingTypeCharacter);
        this.endingPatternString = terms[5];
        switch (this.endingType) {
            case ON_SPECIFIC_DATE: {
                try {
                    this.endsOnDate = dateDf.parse(this.endingPatternString);
                }
                catch (Exception e) {
                    logger.error("unexpected exception", (Throwable)e);
                }
                break;
            }
            case AFTER_N_OCCURENCES: {
                this.endsAfterNDates = this.endingPatternString;
                break;
            }
        }
    }

    public Date getBeginTime() {
        return this.beginTime;
    }

    public void setBeginTime(Date beginTime) {
        this.beginTime = beginTime;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public Date getSeriesStartDate() {
        return this.seriesStartDate;
    }

    public void setSeriesStartDate(Date seriesStartDate) {
        this.seriesStartDate = seriesStartDate;
    }

    public EndingType getEndingType() {
        return this.endingType;
    }

    public void setEndingType(EndingType endingType) {
        this.endingType = endingType;
    }

    public String getSeriesPatternString() {
        return this.seriesPatternString;
    }

    public void setSeriesPatternString(String seriesPatternString) {
        this.seriesPatternString = seriesPatternString;
    }

    public String getEndingPatternString() {
        return this.endingPatternString;
    }

    public void setEndingPatternString(String endingPatternString) {
        this.endingPatternString = endingPatternString;
    }

    public IContact getContact() {
        return this.contact;
    }

    public void setContact(IContact contact) {
        this.contact = contact;
    }

    public String getReason() {
        return this.reason;
    }

    public void setReason(String reason) {
        this.reason = reason;
    }

    public SeriesType getSeriesType() {
        return this.seriesType;
    }

    public void setSeriesType(SeriesType seriesType) {
        this.seriesType = seriesType;
    }

    public Date getEndsOnDate() {
        return this.endsOnDate;
    }

    public void setEndsOnDate(Date endsOnDate) {
        this.endsOnDate = endsOnDate;
    }

    public String getEndsAfterNDates() {
        return this.endsAfterNDates;
    }

    public void setEndsAfterNDates(String endsAfterNDates) {
        this.endsAfterNDates = endsAfterNDates;
    }

    public IAppointment getRootAppoinemtent() {
        return this.rootTermin;
    }

    public String getFreeText() {
        return this.freeText;
    }

    public void setFreeText(String freeText) {
        this.freeText = freeText;
    }
}

