/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.jfr;

import java.io.IOException;
import java.nio.file.Path;
import java.text.ParseException;
import java.time.Duration;
import jdk.jfr.Configuration;
import jdk.jfr.Recording;
import org.osgi.service.component.annotations.Component;

@Component(immediate=true, service={JavaFlightRecorderService.class})
public class JavaFlightRecorderService {
    private Recording recording;

    public void startRecording() throws IOException, ParseException {
        if (this.recording == null) {
            this.recording = new Recording();
        }
        if (this.recording != null) {
            Configuration conf = Configuration.getConfiguration("default");
            this.recording = new Recording(conf);
            this.recording.setMaxAge(Duration.ofMinutes(2L));
            this.recording.setToDisk(false);
            System.gc();
            this.recording.start();
        }
    }

    public void stopRecording() {
        if (this.recording != null) {
            this.recording.stop();
            this.recording = null;
        }
    }

    public void dumpFile(Path filename) throws IOException {
        if (this.recording != null && filename != null) {
            this.recording.dump(filename);
        }
    }

    public boolean isRecording() {
        return this.recording != null;
    }
}

