/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.model.format;

import ch.elexis.core.l10n.Messages;
import ch.elexis.core.model.IContact;
import ch.elexis.core.model.IPerson;
import ch.elexis.core.types.Country;
import ch.elexis.core.types.Gender;
import ch.rgw.tools.StringTool;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.commons.lang3.StringUtils;

public class PostalAddress {
    private IContact contact;
    private String salutation;
    private String address1;
    private String address2;
    private String lastName;
    private String firstName;
    private String country;
    private String zip;
    private String city;

    public String getSalutation() {
        return this.salutation;
    }

    public String getAddress1() {
        return this.address1;
    }

    public String getAddress2() {
        return this.address2;
    }

    public String getLastName() {
        return this.lastName;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public String getCountry() {
        return this.country;
    }

    public String getZip() {
        return this.zip;
    }

    public String getCity() {
        return this.city;
    }

    public static PostalAddress of(IContact contact) {
        PostalAddress ret = new PostalAddress();
        ret.setContact(contact);
        return ret;
    }

    public static PostalAddress ofText(String text) {
        PostalAddress ret = new PostalAddress();
        ret.initFromText(text);
        return ret;
    }

    private void setContact(IContact contact) {
        this.contact = contact;
    }

    public String getWrittenAddress(boolean withName, boolean multiline) {
        String sep = "\n";
        if (!multiline) {
            sep = ", ";
        }
        StringBuilder ret = new StringBuilder(100);
        if (withName) {
            if (this.contact.isPerson()) {
                IPerson person = this.contact.asIPerson();
                String salutation = this.getPersonSalutation(person, multiline);
                ret.append(salutation);
            } else {
                ret.append(this.contact.getDescription1());
                if (StringUtils.isNotEmpty((CharSequence)this.contact.getDescription2())) {
                    ret.append(" " + this.contact.getDescription2());
                }
                if (multiline) {
                    ret.append("\n");
                }
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)this.contact.getStreet())) {
            ret.append(this.contact.getStreet()).append(sep);
        }
        if (this.contact.getCountry() != null && this.contact.getCountry() != Country.NDF) {
            ret.append(this.contact.getCountry().toString()).append(" - ");
        }
        if (StringUtils.isNotEmpty((CharSequence)this.contact.getZip()) && StringUtils.isNotEmpty((CharSequence)this.contact.getCity())) {
            ret.append(this.contact.getZip()).append(" ").append(this.contact.getCity());
        }
        if (multiline) {
            ret.append("\n");
        }
        return ret.toString();
    }

    private String getPersonSalutation(IPerson person, boolean multiline) {
        StringBuilder ret = new StringBuilder();
        String salutation = Gender.MALE == person.getGender() ? Messages.Contact_SalutationM : Messages.Contact_SalutationF;
        ret.append(salutation);
        if (multiline) {
            ret.append("\n");
        } else {
            ret.append(" ");
        }
        if (StringUtils.isNotEmpty((CharSequence)person.getTitel())) {
            ret.append(person.getTitel() + " ");
        }
        ret.append(person.getFirstName() + " " + person.getLastName());
        if (multiline) {
            ret.append("\n");
        }
        return ret.toString();
    }

    public String getLabel() {
        return this.getWrittenAddress(true, false);
    }

    private void initFromText(String text) {
        int index;
        StringTokenizer tokenizer = new StringTokenizer(text, "\n");
        Vector<String> zeileList = new Vector<String>();
        while (tokenizer.hasMoreElements()) {
            zeileList.add(tokenizer.nextToken());
        }
        String plzOrt = "";
        String nameVorname = "";
        int len = zeileList.size();
        switch (len) {
            case 0: {
                throw new IllegalArgumentException("Could not parse postal address");
            }
            case 1: {
                nameVorname = (String)zeileList.get(0);
                break;
            }
            case 2: {
                nameVorname = (String)zeileList.get(0);
                plzOrt = (String)zeileList.get(1);
                break;
            }
            case 3: {
                if (((String)zeileList.get(0)).indexOf(" ") < 0) {
                    this.salutation = (String)zeileList.get(0);
                    nameVorname = (String)zeileList.get(1);
                    plzOrt = (String)zeileList.get(2);
                    break;
                }
                nameVorname = (String)zeileList.get(0);
                this.address1 = (String)zeileList.get(1);
                plzOrt = (String)zeileList.get(2);
                break;
            }
            case 4: {
                if (((String)zeileList.get(0)).indexOf(" ") < 0) {
                    this.salutation = (String)zeileList.get(0);
                    nameVorname = (String)zeileList.get(1);
                    this.address1 = (String)zeileList.get(2);
                    plzOrt = (String)zeileList.get(3);
                    break;
                }
                nameVorname = (String)zeileList.get(0);
                this.address1 = (String)zeileList.get(1);
                this.address2 = (String)zeileList.get(2);
                plzOrt = (String)zeileList.get(3);
                break;
            }
            default: {
                if (len <= 4) break;
                this.salutation = (String)zeileList.get(0);
                nameVorname = (String)zeileList.get(1);
                this.address1 = (String)zeileList.get(2);
                this.address2 = (String)zeileList.get(3);
                plzOrt = (String)zeileList.get(4);
            }
        }
        if (!StringTool.isNothing((Object)nameVorname)) {
            index = (nameVorname = nameVorname.trim()).lastIndexOf(" ");
            if (index > 0) {
                this.lastName = nameVorname.substring(0, index);
                this.firstName = nameVorname.substring(index + 1);
            } else {
                this.lastName = nameVorname;
            }
        }
        if (plzOrt.length() > 3 && plzOrt.substring(0, 3).indexOf("-") > 0) {
            index = plzOrt.indexOf("-");
            this.country = plzOrt.substring(0, index);
            this.city = plzOrt = plzOrt.substring(index + 1);
        }
        if (plzOrt.indexOf(" ") > 0) {
            index = plzOrt.indexOf(" ");
            this.zip = plzOrt.substring(0, index);
            this.city = plzOrt = plzOrt.substring(index + 1);
        }
    }
}

