/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.model.esr;

import ch.elexis.core.interfaces.INumericEnum;
import java.util.HashMap;

public enum ESRRejectCode implements INumericEnum
{
    OK(0),
    ESRREJECT(1),
    MASSENREJECT(2),
    BETRAG(3),
    MANDANT(4),
    RN_NUMMER(5),
    PAT_NUMMER(6),
    DUPLIKAT(7),
    ANDERE(8),
    PAT_FALSCH(9),
    REFERNECE(10);

    private int numeric;
    private static HashMap<Integer, ESRRejectCode> numericMap;

    static {
        numericMap = new HashMap();
    }

    private ESRRejectCode(int numeric) {
        this.numeric = numeric;
    }

    @Override
    public int numericValue() {
        return this.numeric;
    }

    public static ESRRejectCode byNumeric(int numeric) {
        if (numericMap.isEmpty()) {
            ESRRejectCode[] entries = ESRRejectCode.values();
            int i = 0;
            while (i < entries.length) {
                numericMap.put(entries[i].numericValue(), entries[i]);
                ++i;
            }
        }
        return numericMap.getOrDefault(numeric, ANDERE);
    }
}

