/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.model.billable;

import ch.elexis.core.model.IBillable;
import ch.elexis.core.model.IBillableOptifier;
import ch.elexis.core.model.IBilled;
import ch.elexis.core.model.IContact;
import ch.elexis.core.model.IEncounter;
import ch.elexis.core.model.builder.IBilledBuilder;
import ch.elexis.core.services.IContextService;
import ch.elexis.core.services.IModelService;
import ch.rgw.tools.Result;
import java.util.List;

public abstract class AbstractOptifier<T extends IBillable>
implements IBillableOptifier<T> {
    protected IModelService coreModelService;
    protected IContextService contextService;

    public AbstractOptifier(IModelService coreModelService, IContextService contextService) {
        this.coreModelService = coreModelService;
        this.contextService = contextService;
    }

    @Override
    public Result<IBilled> add(T billable, IEncounter encounter, double amount, boolean save) {
        boolean added = false;
        IBilled billed = null;
        List<IBilled> existingBilled = encounter.getBilled();
        for (IBilled iBilled : existingBilled) {
            IBillable existing = iBilled.getBillable();
            if (existing == null || !existing.equals(billable)) continue;
            this.setAmount(iBilled, iBilled.getAmount() + amount);
            if (save) {
                this.coreModelService.save(iBilled);
            }
            billed = iBilled;
            added = true;
            break;
        }
        if (!added) {
            IContact activeUserContact = this.contextService.getActiveUserContact().get();
            billed = (IBilled)new IBilledBuilder(this.coreModelService, (IBillable)billable, encounter, activeUserContact).build();
            this.setPrice(billable, billed);
            this.setAmount(billed, amount);
            if (save) {
                this.coreModelService.save(billed);
            }
        }
        return new Result(billed);
    }

    @Override
    public Result<IBilled> remove(IBilled billed, IEncounter encounter) {
        encounter.removeBilled(billed);
        return new Result((Object)billed);
    }

    protected void setAmount(IBilled billed, double amount) {
        billed.setAmount(amount);
    }

    protected abstract void setPrice(T var1, IBilled var2);

    @Override
    public void putContext(String key, Object value) {
    }

    @Override
    public void clearContext() {
    }
}

