/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.model;

import ch.elexis.core.model.ILabItem;
import ch.elexis.core.types.LabItemTyp;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class LabResultConstants {
    public static final int PATHOLOGIC = 1;
    public static final String SMALLER = "<";
    public static final String BIGGER = ">";
    public static final String EXTINFO_HL7_SUBID = "Hl7SubId";
    public static Pattern refValuesPattern = Pattern.compile("\\((.*?)\\)");
    public static String[] VALID_ABS_VALUES = new String[]{"positiv", "negativ", "pos.", "neg.", "pos", "neg", ">0", "<0"};

    public static boolean isPathologic(ILabItem item, String result, String referenceValues) {
        if (item.getTyp().equals((Object)LabItemTyp.ABSOLUTE)) {
            if (result.toLowerCase().startsWith("pos")) {
                return true;
            }
            if (result.trim().startsWith("+")) {
                return true;
            }
        } else {
            List<String> refStrings = LabResultConstants.parseRefString(referenceValues);
            if (!refStrings.isEmpty() && result != null) {
                return LabResultConstants.testRef(refStrings.get(0), result);
            }
        }
        return false;
    }

    public static List<String> parseRefString(String ref) {
        ArrayList<String> result = new ArrayList<String>();
        Matcher m = refValuesPattern.matcher(ref);
        while (m.find()) {
            result.add(m.group(1).trim());
        }
        if (result.isEmpty()) {
            result.add(ref.trim());
        }
        return result;
    }

    public static boolean testRef(String ref, String result) {
        block9: {
            double val;
            double refVal;
            String resultSign;
            block10: {
                if (!ref.trim().startsWith(SMALLER) && !ref.trim().startsWith(BIGGER)) break block9;
                resultSign = null;
                refVal = Double.parseDouble(ref.substring(1).trim());
                if (result.trim().startsWith(SMALLER) || result.trim().startsWith(BIGGER)) {
                    resultSign = result.substring(0, 1).trim();
                    result = result.substring(1).trim();
                }
                val = Double.parseDouble(result);
                if (!ref.trim().startsWith(SMALLER)) break block10;
                if (val >= refVal && (val != refVal || !SMALLER.equals(resultSign))) {
                    return true;
                }
            }
            if (val <= refVal && (val != refVal || !BIGGER.equals(resultSign))) {
                return true;
            }
        }
        try {
            String[] range = ref.split("\\s*-\\s*");
            if (range.length == 2) {
                double lower = Double.parseDouble(range[0]);
                double upper = Double.parseDouble(range[1]);
                double val = Double.parseDouble(result);
                if (val < lower || val > upper) {
                    return true;
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return false;
    }

    public static boolean isValidNumericRefValue(String value) {
        List<String> refs = LabResultConstants.parseRefString(value);
        for (String string : refs) {
            try {
                if (string.trim().startsWith(SMALLER) || string.trim().startsWith(BIGGER)) {
                    Double.parseDouble(string.substring(1).trim());
                    continue;
                }
                String[] range = string.split("\\s*-\\s*");
                if (range.length == 2) {
                    Double.parseDouble(range[0]);
                    Double.parseDouble(range[1]);
                    continue;
                }
                return false;
            }
            catch (NumberFormatException nfe) {
                return false;
            }
        }
        return true;
    }

    public static boolean isValidAbsoluteRefValue(String value) {
        String[] stringArray = VALID_ABS_VALUES;
        int n = VALID_ABS_VALUES.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            if (value.trim().equals(string)) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

