/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.lock.types;

import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlTransient;
import java.util.Date;

@XmlRootElement
public class LockInfo {
    @XmlTransient
    public static final long EVICTION_TIMEOUT = 30000L;
    @XmlTransient
    private long refreshMillis;
    @XmlElement
    private String elementId;
    @XmlElement
    private String elementType;
    @XmlElement
    private String user;
    @XmlElement
    private Date creationDate;
    @XmlElement
    private String systemUuid;
    @XmlElement
    private String stationId;
    @XmlElement
    private String stationLabel;

    public LockInfo() {
    }

    public LockInfo(String storeToString, String userId, String systemUuid) {
        this(storeToString, userId, systemUuid, "", "");
    }

    public LockInfo(String storeToString, String userId, String systemUuid, String stationId, String stationLabel) {
        String[] split = storeToString.split("::");
        if (split.length != 2) {
            throw new IllegalArgumentException(storeToString);
        }
        this.elementId = split[1];
        this.elementType = split[0];
        this.user = userId;
        this.creationDate = new Date();
        this.systemUuid = systemUuid;
        this.stationId = stationId;
        this.stationLabel = stationLabel;
    }

    public String getElementType() {
        return this.elementType;
    }

    public String getElementId() {
        return this.elementId;
    }

    public String getUser() {
        return this.user;
    }

    public Date getCreationDate() {
        return this.creationDate;
    }

    public String getSystemUuid() {
        return this.systemUuid;
    }

    public String getStationId() {
        return this.stationId;
    }

    public String getStationLabel() {
        return this.stationLabel;
    }

    public static String getElementId(String storeToString) {
        String[] split = storeToString.split("::");
        if (split.length == 2) {
            return split[1];
        }
        throw new IllegalArgumentException(storeToString);
    }

    public String getElementStoreToString() {
        return this.elementType + "::" + this.elementId;
    }

    public void refresh() {
        this.refreshMillis = System.currentTimeMillis();
    }

    public boolean evict(long currentMillis) {
        if (this.refreshMillis == 0L) {
            this.refreshMillis = currentMillis;
        } else if (currentMillis - this.refreshMillis > 30000L) {
            return true;
        }
        return false;
    }

    public String toString() {
        return "LockInfo [elementType=" + this.elementType + ", elementId=" + this.elementId + ", user=" + this.user + ", systemUuid=" + this.systemUuid + ", creationDate=" + String.valueOf(this.creationDate) + ", refreshMillis=" + this.refreshMillis + "]";
    }
}

