/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.types;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum AppointmentType implements Enumerator
{
    DEFAULT(2, "DEFAULT", "DEFAULT"),
    FREE(0, "FREE", "FREE"),
    BOOKED(1, "BOOKED", "BOOKED");

    public static final int DEFAULT_VALUE = 2;
    public static final int FREE_VALUE = 0;
    public static final int BOOKED_VALUE = 1;
    private static final AppointmentType[] VALUES_ARRAY;
    public static final List<AppointmentType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new AppointmentType[]{DEFAULT, FREE, BOOKED};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static AppointmentType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            AppointmentType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static AppointmentType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            AppointmentType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static AppointmentType get(int value) {
        switch (value) {
            case 2: {
                return DEFAULT;
            }
            case 0: {
                return FREE;
            }
            case 1: {
                return BOOKED;
            }
        }
        return null;
    }

    private AppointmentType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

