/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.model.billable;

import ch.elexis.core.model.IBillable;
import ch.elexis.core.model.IBilled;
import ch.elexis.core.model.ICoverage;
import ch.elexis.core.model.IDiagnosisReference;
import ch.elexis.core.model.IEncounter;
import ch.elexis.core.model.billable.AbstractOptifier;
import ch.elexis.core.model.builder.IEncounterBuilder;
import ch.elexis.core.services.IConfigService;
import ch.elexis.core.services.IContextService;
import ch.elexis.core.services.IModelService;
import ch.rgw.tools.Result;
import java.time.LocalDate;
import java.util.List;
import java.util.Optional;

public abstract class AbstractNoObligationOptifier<T extends IBillable>
extends AbstractOptifier<T> {
    private IConfigService configService;
    private IContextService contextService;

    public AbstractNoObligationOptifier(IModelService coreModelService, IConfigService configService, IContextService contextService) {
        super(coreModelService, contextService);
        this.configService = configService;
        this.contextService = contextService;
    }

    @Override
    public Result<IBilled> add(T billable, IEncounter encounter, double amount, boolean save) {
        if (this.isNoObligation(billable)) {
            String law = encounter.getCoverage().getBillingSystem().getLaw().name();
            boolean forceObligation = this.configService.getActiveUserContact("billing/obligation", false);
            if (forceObligation && "KVG".equalsIgnoreCase(law)) {
                IEncounter noOblEncounter = null;
                this.contextService.getRootContext().setNamed("SelectFallNoObligationDialog.coverage", encounter.getCoverage());
                this.contextService.getRootContext().setNamed("SelectFallNoObligationDialog.billable", billable);
                Optional<?> selectedCoverage = this.contextService.getNamed("SelectFallNoObligationDialog");
                if (selectedCoverage.isPresent() && (noOblEncounter = (IEncounter)this.getEncounterByDate((ICoverage)selectedCoverage.get(), encounter.getDate()).orElse(null)) == null) {
                    noOblEncounter = (IEncounter)new IEncounterBuilder(this.coreModelService, (ICoverage)selectedCoverage.get(), this.contextService.getActiveMandator().orElse(null)).build();
                    List<IDiagnosisReference> diagnoses = encounter.getDiagnoses();
                    for (IDiagnosisReference diag : diagnoses) {
                        noOblEncounter.addDiagnosis(diag);
                    }
                    this.coreModelService.save(noOblEncounter);
                }
                this.contextService.getRootContext().setNamed("SelectFallNoObligationDialog.coverage", null);
                this.contextService.getRootContext().setNamed("SelectFallNoObligationDialog.billable", null);
                if (noOblEncounter != null) {
                    encounter = noOblEncounter;
                } else {
                    return new Result(Result.SEVERITY.WARNING, 0, "Auf diesen Fall k\u00f6nnen nur Pflichtleistungen verrechnet werden. Bitte einen separaten Fall f\u00fcr Nichtpflichtleistungen anlegen.", null, false);
                }
            }
        }
        return super.add(billable, encounter, amount, save);
    }

    private Optional<IEncounter> getEncounterByDate(ICoverage coverage, LocalDate date) {
        return coverage.getEncounters().stream().filter(e -> e.getDate().equals(date)).findFirst();
    }

    protected abstract boolean isNoObligation(T var1);
}

