/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.webdav.internal;

import ch.elexis.core.webdav.WebdavFile;
import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.url.AbstractURLStreamHandlerService;
import org.osgi.service.url.URLStreamHandlerService;

@Component(immediate=true, service={URLStreamHandlerService.class}, property={"url.handler.protocol:String=dav"})
public class UnsafeWebdavURLStreamHandlerService
extends AbstractURLStreamHandlerService {
    public URLConnection openConnection(URL url) throws IOException {
        if (url.getUserInfo() != null && !"localhost".equals(url.getHost())) {
            throw new IOException("No unencrypted, authenticated communication to external hosts allowed. Use davs.");
        }
        String replaced = url.toString().replaceFirst("dav", "http");
        return new WebdavFile(new URL(replaced));
    }
}

