/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.scripting;

import java.io.PrintStream;
import java.io.PrintWriter;
import org.eclipse.core.runtime.IStatus;

public class ScriptingException
extends RuntimeException {
    private final IStatus status;

    public ScriptingException(IStatus status) {
        super(status.getMessage());
        this.status = status;
    }

    @Override
    public Throwable getCause() {
        return this.status.getException();
    }

    public final IStatus getStatus() {
        return this.status;
    }

    @Override
    public void printStackTrace() {
        this.printStackTrace(System.err);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void printStackTrace(PrintStream output) {
        PrintStream printStream = output;
        synchronized (printStream) {
            super.printStackTrace(output);
            ScriptingException.printChildren(this.status, output);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void printStackTrace(PrintWriter output) {
        PrintWriter printWriter = output;
        synchronized (printWriter) {
            super.printStackTrace(output);
            ScriptingException.printChildren(this.status, output);
        }
    }

    public static void printChildren(IStatus status, PrintStream output) {
        IStatus[] children = status.getChildren();
        if (children == null || children.length == 0) {
            return;
        }
        int i = 0;
        while (i < children.length) {
            output.println("Contains: " + children[i].getMessage());
            Throwable exception = children[i].getException();
            if (exception != null) {
                exception.printStackTrace(output);
            }
            ScriptingException.printChildren(children[i], output);
            ++i;
        }
    }

    public static void printChildren(IStatus status, PrintWriter output) {
        IStatus[] children = status.getChildren();
        if (children == null || children.length == 0) {
            return;
        }
        int i = 0;
        while (i < children.length) {
            output.println("Contains: " + children[i].getMessage());
            output.flush();
            Throwable exception = children[i].getException();
            if (exception != null) {
                exception.printStackTrace(output);
            }
            ScriptingException.printChildren(children[i], output);
            ++i;
        }
    }
}

