/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.views.rechnung.invoice;

import ch.elexis.core.model.InvoiceState;
import ch.elexis.core.ui.UiDesk;
import ch.elexis.core.ui.dialogs.KontaktSelektor;
import ch.elexis.core.ui.icons.Images;
import ch.elexis.core.ui.preferences.UserCasePreferences;
import ch.elexis.core.ui.selectors.Messages;
import ch.elexis.core.ui.views.rechnung.InvoiceListView;
import ch.elexis.data.BillingSystem;
import ch.elexis.data.Patient;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;

public class InvoiceListHeaderComposite
extends Composite {
    private static final String ALL_PATIENTS_LABEL = ch.elexis.core.l10n.Messages.RnControlFieldProvider_allPatients;
    private static final String ALL_ELEMENTS_LABEL = ch.elexis.core.l10n.Messages.Core_All;
    private Text txtInvoiceno;
    private Text txtAmount;
    private Patient actPatient;
    private Link linkPatient;
    private ComboViewer comboViewerStatus;
    private Label lblPatientname;
    private ComboViewer comboViewerType;
    private Button btnLimit;
    private ComboViewer comboViewerBillingSystem;
    private Color defaultBackgroundColor;
    private Label lblLimitWarn;

    public InvoiceListHeaderComposite(final Composite parent, int style, final InvoiceListView invoiceListView) {
        super(parent, style);
        this.setLayout((Layout)new GridLayout(8, false));
        this.setLayoutData(new GridData(4, 0x1000000, true, false, 1, 1));
        new Label((Composite)this, 0);
        Label lblStatus = new Label((Composite)this, 0);
        lblStatus.setLayoutData((Object)new GridData(16384, 0x1000000, true, false, 1, 1));
        lblStatus.setText(ch.elexis.core.l10n.Messages.Core_Invoicestate);
        final HyperlinkAdapter hlPatient = new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                Patient oldPatient = InvoiceListHeaderComposite.this.actPatient;
                KontaktSelektor ksl = new KontaktSelektor(parent.getShell(), Patient.class, ch.elexis.core.l10n.Messages.Core_Select_Patient, ch.elexis.core.l10n.Messages.RnControlFieldProvider_selectPatientMessage, true, new String[0]);
                if (ksl.open() == 0) {
                    InvoiceListHeaderComposite.this.actPatient = (Patient)ksl.getSelection();
                    if (InvoiceListHeaderComposite.this.actPatient != null) {
                        InvoiceListHeaderComposite.this.lblPatientname.setText(InvoiceListHeaderComposite.this.actPatient.getLabel());
                        InvoiceListHeaderComposite.this.comboViewerStatus.setSelection((ISelection)new StructuredSelection((Object)ALL_ELEMENTS_LABEL));
                    } else {
                        InvoiceListHeaderComposite.this.lblPatientname.setText(ALL_PATIENTS_LABEL);
                        InvoiceListHeaderComposite.this.comboViewerStatus.setSelection((ISelection)new StructuredSelection((Object)InvoiceState.OPEN));
                    }
                } else {
                    InvoiceListHeaderComposite.this.actPatient = null;
                    InvoiceListHeaderComposite.this.lblPatientname.setText(ALL_PATIENTS_LABEL);
                    InvoiceListHeaderComposite.this.comboViewerStatus.setSelection((ISelection)new StructuredSelection((Object)InvoiceState.OPEN));
                }
                if (InvoiceListHeaderComposite.this.actPatient == null && oldPatient == null) {
                    return;
                }
                if (InvoiceListHeaderComposite.this.actPatient != null && oldPatient != null && InvoiceListHeaderComposite.this.actPatient.equals((Object)oldPatient)) {
                    return;
                }
                invoiceListView.refresh();
            }
        };
        this.linkPatient = new Link((Composite)this, 0);
        this.linkPatient.setLayoutData((Object)new GridData(16384, 0x1000000, true, false, 1, 1));
        this.linkPatient.setText(ch.elexis.core.l10n.Messages.RnControlFieldProvider_patient2);
        this.linkPatient.setForeground(UiDesk.getColorRegistry().get("blau"));
        this.linkPatient.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                if (hlPatient != null) {
                    hlPatient.linkActivated(new HyperlinkEvent((Widget)InvoiceListHeaderComposite.this.linkPatient, (Object)InvoiceListHeaderComposite.this.linkPatient, InvoiceListHeaderComposite.this.linkPatient.getText(), e.stateMask));
                }
            }
        });
        Label lblBillingSystem = new Label((Composite)this, 0);
        lblBillingSystem.setLayoutData((Object)new GridData(16384, 0x1000000, true, false, 1, 1));
        lblBillingSystem.setText(ch.elexis.core.l10n.Messages.Invoice_System);
        Label lblType = new Label((Composite)this, 0);
        lblType.setText(ch.elexis.core.l10n.Messages.Core_Kind);
        lblType.setLayoutData((Object)new GridData(16384, 0x1000000, true, false, 1, 1));
        Label lblInvoiceno = new Label((Composite)this, 0);
        lblInvoiceno.setLayoutData((Object)new GridData(16384, 0x1000000, true, false, 1, 1));
        lblInvoiceno.setText(ch.elexis.core.l10n.Messages.InvoiceListView_tblclmnInvoiceNo_text);
        Label lblAmount = new Label((Composite)this, 0);
        lblAmount.setLayoutData((Object)new GridData(16384, 0x1000000, true, false, 1, 1));
        lblAmount.setText(ch.elexis.core.l10n.Messages.Core_Invoice_total_amount);
        lblAmount.setToolTipText(ch.elexis.core.l10n.Messages.InvoiceListHeaderComposite_txtAmount_toolTipText);
        this.lblLimitWarn = new Label((Composite)this, 0);
        this.lblLimitWarn.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.lblLimitWarn.setText("");
        this.defaultBackgroundColor = this.lblLimitWarn.getBackground();
        Label btnClear = new Label((Composite)this, 0x800000);
        btnClear.setImage(Images.IMG_CLEAR.getImage());
        btnClear.setToolTipText(Messages.SelectorPanel_clearFields);
        btnClear.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                InvoiceListHeaderComposite.this.clearValues();
                invoiceListView.refresh();
            }
        });
        this.comboViewerStatus = new ComboViewer((Composite)this, 12);
        Combo comboStatus = this.comboViewerStatus.getCombo();
        GridData gd_comboStatus = new GridData(4, 0x1000000, false, false, 1, 1);
        gd_comboStatus.widthHint = 140;
        comboStatus.setLayoutData((Object)gd_comboStatus);
        this.comboViewerStatus.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.comboViewerStatus.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof InvoiceState) {
                    InvoiceState invoiceState = (InvoiceState)element;
                    return invoiceState.getLocaleText();
                }
                return super.getText(element);
            }
        });
        ArrayList<String> values = new ArrayList<String>();
        values.add(ALL_ELEMENTS_LABEL);
        values.add((String)InvoiceState.OPEN);
        values.add((String)InvoiceState.OPEN_AND_PRINTED);
        values.add((String)InvoiceState.PARTIAL_PAYMENT);
        values.add((String)InvoiceState.PAID);
        values.add((String)InvoiceState.EXCESSIVE_PAYMENT);
        values.add((String)InvoiceState.DEMAND_NOTE_1);
        values.add((String)InvoiceState.DEMAND_NOTE_1_PRINTED);
        values.add((String)InvoiceState.DEMAND_NOTE_2);
        values.add((String)InvoiceState.DEMAND_NOTE_2_PRINTED);
        values.add((String)InvoiceState.DEMAND_NOTE_3);
        values.add((String)InvoiceState.DEMAND_NOTE_3_PRINTED);
        values.add((String)InvoiceState.IN_EXECUTION);
        values.add((String)InvoiceState.PARTIAL_LOSS);
        values.add((String)InvoiceState.TOTAL_LOSS);
        values.add((String)InvoiceState.CANCELLED);
        values.add((String)InvoiceState.DEFECTIVE);
        values.add((String)InvoiceState.TO_PRINT);
        values.add((String)InvoiceState.OWING);
        values.add((String)InvoiceState.STOP_LEGAL_PROCEEDING);
        values.add((String)InvoiceState.DEPRECIATED);
        values.add((String)InvoiceState.REJECTED);
        this.comboViewerStatus.setInput(values);
        this.comboViewerStatus.setSelection((ISelection)new StructuredSelection((Object)InvoiceState.OPEN));
        this.comboViewerStatus.addSelectionChangedListener(event -> invoiceListView.refresh());
        this.lblPatientname = new Label((Composite)this, 0);
        GridData gd_lblPatientname = new GridData(4, 0x1000000, true, false, 1, 1);
        gd_lblPatientname.minimumWidth = 130;
        this.lblPatientname.setLayoutData((Object)gd_lblPatientname);
        this.lblPatientname.setText(ALL_PATIENTS_LABEL);
        this.comboViewerBillingSystem = new ComboViewer((Composite)this, 12);
        this.comboViewerBillingSystem.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.comboViewerBillingSystem.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        ArrayList<String> billingSystems = new ArrayList<String>();
        billingSystems.add(ALL_ELEMENTS_LABEL);
        billingSystems.addAll(Arrays.asList(this.getBillingSystems()));
        this.comboViewerBillingSystem.setInput(billingSystems);
        this.comboViewerBillingSystem.setSelection((ISelection)new StructuredSelection((Object)ALL_ELEMENTS_LABEL));
        this.comboViewerBillingSystem.getCombo().setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.comboViewerBillingSystem.addSelectionChangedListener(event -> invoiceListView.refresh());
        this.comboViewerType = new ComboViewer((Composite)this, 12);
        this.comboViewerType.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.comboViewerType.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        this.comboViewerType.setInput(Arrays.asList(ALL_ELEMENTS_LABEL, "TG", "TP"));
        this.comboViewerType.setSelection((ISelection)new StructuredSelection((Object)ALL_ELEMENTS_LABEL));
        this.comboViewerType.getCombo().setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.comboViewerType.addSelectionChangedListener(event -> invoiceListView.refresh());
        this.txtInvoiceno = new Text((Composite)this, 2048);
        this.txtInvoiceno.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.txtInvoiceno.addListener(31, new Listener(){

            public void handleEvent(Event event) {
                if (event.detail == 4) {
                    InvoiceListHeaderComposite.this.comboViewerStatus.setSelection((ISelection)new StructuredSelection((Object)ALL_ELEMENTS_LABEL));
                }
            }
        });
        this.txtAmount = new Text((Composite)this, 2048);
        this.txtAmount.setToolTipText(ch.elexis.core.l10n.Messages.InvoiceListHeaderComposite_txtAmount_toolTipText);
        this.txtAmount.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.txtAmount.addListener(31, new Listener(){

            public void handleEvent(Event event) {
                if (event.detail == 4) {
                    invoiceListView.refresh();
                }
            }
        });
        this.btnLimit = new Button((Composite)this, 25165826);
        this.btnLimit.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean selection = InvoiceListHeaderComposite.this.btnLimit.getSelection();
                invoiceListView.getInvoiceListContentProvider().setQueryLimit(selection ? 1000 : -1);
                invoiceListView.refresh();
            }
        });
        this.btnLimit.setSelection(true);
        this.btnLimit.setToolTipText(ch.elexis.core.l10n.Messages.InvoiceListHeaderComposite_btnLimit_toolTipText);
        this.btnLimit.setImage(Images.IMG_COUNTER_STOP.getImage());
    }

    protected void checkSubclass() {
    }

    private String[] getBillingSystems() {
        String[] abrechnungsSysteme = BillingSystem.getAbrechnungsSysteme();
        if (abrechnungsSysteme != null) {
            abrechnungsSysteme = UserCasePreferences.sortBillingSystems(abrechnungsSysteme);
        }
        return abrechnungsSysteme;
    }

    private void clearValues() {
        this.comboViewerStatus.setSelection((ISelection)new StructuredSelection((Object)InvoiceState.OPEN));
        this.actPatient = null;
        this.comboViewerBillingSystem.setSelection((ISelection)new StructuredSelection((Object)ALL_ELEMENTS_LABEL));
        this.comboViewerType.setSelection((ISelection)new StructuredSelection((Object)ALL_ELEMENTS_LABEL));
        this.txtInvoiceno.setText("");
        this.txtAmount.setText("");
        this.lblPatientname.setText(ALL_PATIENTS_LABEL);
    }

    Integer getSelectedInvoiceStateNo() {
        Object firstElement;
        StructuredSelection ss = (StructuredSelection)this.comboViewerStatus.getSelection();
        if (!ss.isEmpty() && (firstElement = ss.getFirstElement()) instanceof InvoiceState) {
            return ((InvoiceState)firstElement).numericValue();
        }
        return null;
    }

    String getSelectedInvoiceType() {
        Object firstElement;
        StructuredSelection ss = (StructuredSelection)this.comboViewerType.getSelection();
        if (!ss.isEmpty() && (firstElement = ss.getFirstElement()) != ALL_ELEMENTS_LABEL) {
            return (String)firstElement;
        }
        return null;
    }

    String getSelectedBillingSystem() {
        Object firstElement;
        StructuredSelection ss = (StructuredSelection)this.comboViewerBillingSystem.getSelection();
        if (!ss.isEmpty() && (firstElement = ss.getFirstElement()) != ALL_ELEMENTS_LABEL) {
            return (String)firstElement;
        }
        return null;
    }

    String getSelectedPatientId() {
        if (this.actPatient != null) {
            return this.actPatient.getId();
        }
        return null;
    }

    public void setSelectedPatientId(Patient patient) {
        this.actPatient = patient;
        this.lblPatientname.setText(this.actPatient.getLabel());
    }

    String getSelectedInvoiceId() {
        return this.txtInvoiceno.getText();
    }

    String getSelectedTotalAmount() {
        return this.txtAmount.getText();
    }

    public void setLimitWarning(Integer queryLimit) {
        if (queryLimit != null) {
            float val = (float)queryLimit.intValue() / 1000.0f;
            this.lblLimitWarn.setText(val + "k");
            this.lblLimitWarn.setToolTipText(String.format(ch.elexis.core.l10n.Messages.InvoiceListHeaderComposite_queryLimit_toolTipText, queryLimit));
            this.lblLimitWarn.setBackground(UiDesk.getColor("rot"));
        } else {
            this.lblLimitWarn.setText("");
            this.lblLimitWarn.setToolTipText("");
            this.lblLimitWarn.setBackground(this.defaultBackgroundColor);
        }
    }
}

