/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.views.provider;

import ch.elexis.core.model.IOrderEntry;
import ch.elexis.core.model.OrderEntryState;
import ch.elexis.core.ui.util.OrderManagementUtil;
import ch.elexis.core.ui.views.OrderManagementView;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

public class EntryTableLabelProvider
extends ColumnLabelProvider {
    private final int columnIndex;
    private final OrderManagementView orderManagementView;

    public EntryTableLabelProvider(int columnIndex, boolean ignored, OrderManagementView orderManagementView) {
        this.columnIndex = columnIndex;
        this.orderManagementView = orderManagementView;
    }

    public String getText(Object element) {
        if (element instanceof IOrderEntry) {
            IOrderEntry entry = (IOrderEntry)element;
            int ordered = entry.getAmount();
            String articleName = entry.getArticle() != null ? entry.getArticle().getName() : "";
            String providerLabel = entry.getProvider() != null ? entry.getProvider().getLabel() : "Unknown";
            String stockCode = entry.getStock() != null ? entry.getStock().getCode() : "N/A";
            switch (this.columnIndex) {
                case 1: {
                    return " ";
                }
                case 2: {
                    return String.valueOf(ordered);
                }
                case 3: {
                    int base = entry.getDelivered();
                    int delta = this.orderManagementView.getPendingDeliveredValues().getOrDefault(entry, 0);
                    return delta > 0 ? base + " (+" + delta + ")" : String.valueOf(base);
                }
                case 4: {
                    if (this.orderManagementView != null) {
                        Integer pendingValue = this.orderManagementView.getPendingDeliveredValues().get(entry);
                        return pendingValue != null ? String.valueOf(pendingValue) : "";
                    }
                    return "";
                }
                case 5: {
                    return articleName;
                }
                case 6: {
                    return providerLabel;
                }
                case 7: {
                    return stockCode;
                }
            }
            return "";
        }
        return "";
    }

    public Image getImage(Object element) {
        if (element instanceof IOrderEntry) {
            IOrderEntry entry = (IOrderEntry)element;
            if (this.columnIndex == 1 && entry.getState() != OrderEntryState.OPEN) {
                Image icon = OrderManagementUtil.getEntryStatusIcon(entry);
                return icon;
            }
        }
        return null;
    }

    public Color getBackground(Object element) {
        if (element instanceof IOrderEntry) {
            IOrderEntry entry = (IOrderEntry)element;
            if (this.columnIndex == 4 && this.orderManagementView.isDeliveryEditMode() && (entry.getState() == OrderEntryState.ORDERED || entry.getState() == OrderEntryState.PARTIAL_DELIVER)) {
                return Display.getDefault().getSystemColor(1);
            }
        }
        return null;
    }
}

