/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.views;

import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.l10n.Messages;
import ch.elexis.core.ui.icons.Images;
import ch.elexis.core.ui.util.viewers.DefaultLabelProvider;
import ch.elexis.core.ui.views.MakroDetailComposite;
import ch.elexis.data.Anwender;
import ch.elexis.data.PersistentObject;
import ch.elexis.data.dto.MakroDTO;
import ch.rgw.io.SqlSettings;
import ch.rgw.tools.JdbcLink;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.slf4j.LoggerFactory;

public class MakrosComposite
extends Composite {
    private TableViewer viewer;
    private MakroDetailComposite detailComposite;

    public MakrosComposite(Composite parent, int style) {
        super(parent, style);
        this.setLayout((Layout)new GridLayout(1, false));
        CLabel lblHeader = new CLabel((Composite)this, 0);
        lblHeader.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        lblHeader.setText("Makros des Anwender " + CoreHub.getLoggedInContact().getLabel());
        SashForm sash = new SashForm((Composite)this, 256);
        sash.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        Composite selectionComposite = new Composite((Composite)sash, 0);
        selectionComposite.setLayout((Layout)new GridLayout(1, true));
        ToolBarManager toolbar = new ToolBarManager();
        ToolBar toolbarControl = toolbar.createControl(selectionComposite);
        toolbarControl.setLayoutData((Object)new GridData(131072, 128, false, false));
        this.viewer = new TableViewer(selectionComposite, 67586);
        this.viewer.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new DefaultLabelProvider());
        this.viewer.setInput(this.getUserMakros(CoreHub.getLoggedInContact()));
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                StructuredSelection selection = (StructuredSelection)MakrosComposite.this.viewer.getSelection();
                if (selection != null && !selection.isEmpty()) {
                    MakrosComposite.this.detailComposite.setMakro((MakroDTO)selection.getFirstElement());
                } else {
                    MakrosComposite.this.detailComposite.setMakro(null);
                }
            }
        });
        this.viewer.setComparator(new ViewerComparator());
        MenuManager menuManager = new MenuManager();
        menuManager.add((IAction)new RemoveMakroAction((StructuredViewer)this.viewer));
        MenuManager subMenu = new MenuManager("Makro zu Anwender kopieren");
        subMenu.setRemoveAllWhenShown(true);
        subMenu.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                MakrosComposite.this.addCopyToUserActions(manager);
            }
        });
        menuManager.add((IContributionItem)subMenu);
        Menu menu = menuManager.createContextMenu((Control)this.viewer.getTable());
        this.viewer.getTable().setMenu(menu);
        toolbar.add((IAction)new AddMakroAction((StructuredViewer)this.viewer));
        toolbar.add((IAction)new RemoveMakroAction((StructuredViewer)this.viewer));
        toolbar.add((IAction)new RefreshMakrosAction((StructuredViewer)this.viewer));
        toolbar.update(true);
        this.detailComposite = new MakroDetailComposite((Composite)sash, 0);
        sash.setWeights(new int[]{1, 4});
    }

    private List<MakroDTO> getUserMakros(Anwender actUser) {
        PreparedStatement statement = null;
        try {
            statement = PersistentObject.getDefaultConnection().getPreparedStatement("SELECT Param, Value FROM USERCONFIG WHERE UserID=? AND Param LIKE ?");
            statement.setString(1, actUser.getId());
            statement.setString(2, "makros/%");
            ArrayList<MakroDTO> items = new ArrayList<MakroDTO>();
            ResultSet rs = statement.executeQuery();
            while (rs.next()) {
                String param = rs.getString(1);
                String name = rs.getString(1).substring(rs.getString(1).indexOf(47) + 1);
                StringBuilder sb = new StringBuilder(name);
                MakroDTO item = new MakroDTO(actUser.getId(), param, sb.reverse().toString(), rs.getString(2));
                items.add(item);
            }
            rs.close();
            statement.close();
            ArrayList<MakroDTO> arrayList = items;
            return arrayList;
        }
        catch (SQLException e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Could not fetch makros", (Throwable)e);
        }
        finally {
            if (statement != null) {
                PersistentObject.getDefaultConnection().releasePreparedStatement(statement);
            }
        }
        return Collections.emptyList();
    }

    private void addCopyToUserActions(IMenuManager manager) {
        List users = CoreHub.getUserList();
        for (Anwender anwender : users) {
            if (anwender.equals((Object)CoreHub.getLoggedInContact())) continue;
            manager.add((IAction)new CopyToUserAction(anwender, (StructuredViewer)this.viewer));
        }
    }

    private class AddMakroAction
    extends Action {
        private StructuredViewer viewer;

        public AddMakroAction(StructuredViewer viewer) {
            this.viewer = viewer;
        }

        public ImageDescriptor getImageDescriptor() {
            return Images.IMG_NEW.getImageDescriptor();
        }

        public void run() {
            InputDialog in = new InputDialog(MakrosComposite.this.getShell(), Messages.EnhancedTextField_newMacro, Messages.EnhancedTextField_enterNameforMacro, null, null);
            if (in.open() == 0) {
                StringBuilder name = new StringBuilder(in.getValue());
                name.reverse();
                MakroDetailComposite.saveMakro(new MakroDTO(CoreHub.getLoggedInContact().getId(), "makros/" + name.toString(), in.getValue(), "Neues Makro"));
                if (this.viewer != null) {
                    this.viewer.setInput(MakrosComposite.this.getUserMakros(CoreHub.getLoggedInContact()));
                }
            }
        }
    }

    private class CopyToUserAction
    extends Action {
        private StructuredViewer viewer;
        private Anwender user;

        public CopyToUserAction(Anwender anwender, StructuredViewer viewer) {
            this.viewer = viewer;
            this.user = anwender;
        }

        public ImageDescriptor getImageDescriptor() {
            return Images.IMG_USER_SILHOUETTE.getImageDescriptor();
        }

        public String getText() {
            return "zu " + this.user.getLabel() + " kopieren";
        }

        public void run() {
            StructuredSelection selection = (StructuredSelection)this.viewer.getSelection();
            if (selection != null && !selection.isEmpty()) {
                for (Object obj : selection.toList()) {
                    if (!(obj instanceof MakroDTO)) continue;
                    MakroDTO makro = (MakroDTO)obj;
                    if (this.copyExists(makro)) {
                        if (!MessageDialog.openConfirm((Shell)MakrosComposite.this.getShell(), (String)"Makro kopieren", (String)("Das Makro " + makro.getMakroName() + " existiert bei " + this.user.getLabel() + " bereits. Wollen Sie das Makro \u00fcberschreiben?"))) continue;
                        this.copy(makro);
                        continue;
                    }
                    this.copy(makro);
                }
            }
        }

        private void copy(MakroDTO makro) {
            MakroDTO copy = new MakroDTO(this.user.getId(), makro.getMakroParam(), makro.getMakroName(), makro.getMakroContent());
            MakroDetailComposite.saveMakro(copy);
        }

        private boolean copyExists(MakroDTO makro) {
            SqlSettings userSettings = new SqlSettings(PersistentObject.getDefaultConnection().getJdbcLink(), "USERCONFIG", "Param", "Value", "UserID=" + JdbcLink.wrap((String)this.user.getId()));
            return userSettings.get(makro.getMakroParam(), null) != null;
        }
    }

    private class RefreshMakrosAction
    extends Action {
        private StructuredViewer viewer;

        public RefreshMakrosAction(StructuredViewer viewer) {
            this.viewer = viewer;
        }

        public ImageDescriptor getImageDescriptor() {
            return Images.IMG_REFRESH.getImageDescriptor();
        }

        public void run() {
            if (this.viewer != null) {
                this.viewer.setInput(MakrosComposite.this.getUserMakros(CoreHub.getLoggedInContact()));
            }
        }
    }

    private class RemoveMakroAction
    extends Action {
        private StructuredViewer viewer;

        public RemoveMakroAction(StructuredViewer viewer) {
            this.viewer = viewer;
        }

        public ImageDescriptor getImageDescriptor() {
            return Images.IMG_DELETE.getImageDescriptor();
        }

        public String getText() {
            return "l\u00f6schen";
        }

        public void run() {
            StructuredSelection selection = (StructuredSelection)this.viewer.getSelection();
            if (selection != null && !selection.isEmpty() && MessageDialog.openConfirm((Shell)MakrosComposite.this.getShell(), (String)"Makros l\u00f6schen", (String)"M\u00f6chten Sie die Makros wirklich l\u00f6schen?")) {
                for (Object obj : selection.toList()) {
                    if (!(obj instanceof MakroDTO)) continue;
                    MakroDetailComposite.removeMakro((MakroDTO)obj);
                }
                if (this.viewer != null) {
                    this.viewer.setInput(MakrosComposite.this.getUserMakros(CoreHub.getLoggedInContact()));
                }
            }
        }
    }
}

