/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.views;

import ch.elexis.core.services.holder.ConfigServiceHolder;
import ch.elexis.core.ui.icons.Images;
import ch.elexis.core.ui.views.Messages;
import com.equo.chromium.swt.Browser;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.LinkedList;
import java.util.function.Consumer;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.ui.part.ViewPart;

public class BrowserView
extends ViewPart {
    public static final String ID = "ch.elexis.core.ui.chromium.views.BrowserView";
    private Browser browser;
    private Combo addressBarCombo;
    private LinkedList<String> history = new LinkedList();
    private int currentHistoryIndex = -1;
    private static final String BROWSER_HISTORY_KEY = "browserHistory";
    private static final String BROWSER_FAVORIT_KEY = "browserFavorites";
    private static final String LAST_URL_KEY = "browserLastUrl";
    private static final String SEARCH_ENGINE_URL = "https://www.google.com/search?q=";
    private LinkedList<String> favorites = new LinkedList();
    private Composite favoritesBar;
    private static final int MAX_FAVORITES = 10;
    private static final int MAX_HISTORY_SIZE = 20;

    public void createPartControl(Composite parent) {
        parent.setLayout((Layout)new GridLayout(5, false));
        Button backButton = this.createButton(parent, Images.IMG_PREVIOUS.getImage(), Messages.Web_Button_Back, b -> this.goBack());
        Button forwardButton = this.createButton(parent, Images.IMG_NEXT.getImage(), Messages.Web_Button_Forward, b -> this.goForward());
        Button reloadButton = this.createButton(parent, Images.IMG_REFRESH.getImage(), Messages.Web_Button_Reload, b -> this.browser.refresh());
        this.addressBarCombo = new Combo(parent, 4);
        this.addressBarCombo.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        String lastUrl = ConfigServiceHolder.getUser((String)LAST_URL_KEY, (String)"http://www.google.com");
        this.addressBarCombo.setText(lastUrl);
        this.addressBarCombo.addListener(13, event -> {
            int selectedIndex = this.addressBarCombo.getSelectionIndex();
            if (selectedIndex >= 0) {
                this.browser.setUrl(this.addressBarCombo.getItem(selectedIndex));
            }
        });
        this.addressBarCombo.addListener(31, event -> {
            if (event.detail == 4) {
                String enteredText = this.addressBarCombo.getText();
                Object urlToLoad = this.isValidUrl(enteredText) ? this.normalizeUrl(enteredText) : SEARCH_ENGINE_URL + this.encodeURIComponent(enteredText);
                this.browser.setUrl((String)urlToLoad);
                if (this.isValidUrl((String)urlToLoad)) {
                    this.updateHistory((String)urlToLoad);
                } else {
                    this.updateHistory(SEARCH_ENGINE_URL + this.encodeURIComponent(enteredText));
                }
            }
        });
        this.addressBarCombo.addListener(31, event -> {
            if (event.detail == 4) {
                String enteredText = this.addressBarCombo.getText();
                this.loadUrlOrSearch(enteredText);
            }
        });
        this.addressBarCombo.addListener(35, event -> this.createAddressBarContextMenu());
        Button favoritesButton = this.createButton(parent, Images.IMG_STAR.getImage(), Messages.Web_Button_Favoriten, b -> this.addFavorite(this.browser.getUrl()));
        this.favoritesBar = new Composite(parent, 0);
        GridData gridData = new GridData(4, 0x1000000, true, false, 4, 1);
        gridData.heightHint = 30;
        this.favoritesBar.setLayoutData((Object)gridData);
        this.favoritesBar.setLayout((Layout)new RowLayout(256));
        this.browser = new Browser(parent, 0);
        GridData browserLayoutData = new GridData(4, 4, true, true);
        browserLayoutData.horizontalSpan = 4;
        this.browser.setLayoutData((Object)browserLayoutData);
        this.browser.setUrl(this.addressBarCombo.getText());
        this.browser.addLocationListener(new LocationListener(){

            public void changed(LocationEvent event) {
                Display.getCurrent().asyncExec(() -> {
                    String newUrl = locationEvent.location;
                    BrowserView.this.addressBarCombo.setText(newUrl);
                    if (BrowserView.this.currentHistoryIndex >= 0 && !newUrl.equals(BrowserView.this.history.get(BrowserView.this.currentHistoryIndex))) {
                        BrowserView.this.history.set(BrowserView.this.currentHistoryIndex, newUrl);
                    } else {
                        BrowserView.this.updateHistory(newUrl);
                    }
                    ConfigServiceHolder.setUser((String)BrowserView.LAST_URL_KEY, (String)newUrl);
                });
            }

            public void changing(LocationEvent event) {
            }
        });
        this.loadHistory();
        this.loadFavorites();
    }

    public void setFocus() {
        this.addressBarCombo.setFocus();
    }

    private void updateHistory(String url) {
        if (this.currentHistoryIndex < 0 || !this.history.get(this.currentHistoryIndex).equals(url)) {
            if (this.history.size() >= 20) {
                this.history.removeLast();
                this.addressBarCombo.remove(this.addressBarCombo.getItemCount() - 1);
            }
            this.history.addFirst(url);
            this.currentHistoryIndex = 0;
            if (this.addressBarCombo.indexOf(url) < 0) {
                this.addressBarCombo.add(url, 0);
            }
        }
    }

    public void goBack() {
        if (this.currentHistoryIndex < this.history.size() - 1) {
            ++this.currentHistoryIndex;
            String url = this.history.get(this.currentHistoryIndex);
            this.browser.setUrl(url);
            this.addressBarCombo.setText(url);
        }
    }

    public void goForward() {
        if (this.currentHistoryIndex > 0) {
            --this.currentHistoryIndex;
            String url = this.history.get(this.currentHistoryIndex);
            this.browser.setUrl(url);
            this.addressBarCombo.setText(url);
        }
    }

    public void dispose() {
        this.saveHistory();
        super.dispose();
    }

    private void saveHistory() {
        String historyString = String.join((CharSequence)";", this.history);
        ConfigServiceHolder.setUser((String)BROWSER_HISTORY_KEY, (String)historyString);
    }

    private void loadHistory() {
        String historyString = ConfigServiceHolder.getUser((String)BROWSER_HISTORY_KEY, (String)"");
        if (!historyString.isEmpty()) {
            String[] urls = historyString.split(";");
            int i = urls.length - 1;
            while (i >= 0) {
                String url = urls[i];
                this.history.addFirst(url);
                this.addressBarCombo.add(url, 0);
                --i;
            }
            this.currentHistoryIndex = 0;
        }
    }

    private void addFavorite(String url) {
        if (this.favorites.size() >= 10) {
            Display.getCurrent().asyncExec(() -> {
                MessageBox messageBox = new MessageBox(Display.getCurrent().getActiveShell(), 40);
                messageBox.setText(Messages.Web_Favorit_Limit);
                messageBox.setMessage(Messages.Web_Favorit_Limit_Text);
                messageBox.open();
            });
            return;
        }
        if (!this.favorites.contains(url)) {
            this.favorites.add(url);
            Button favoriteButton = this.createButton(this.favoritesBar, Images.IMG_STAR.getImage(), url, b -> {
                this.browser.setUrl(url);
                this.updateHistory(url);
            });
            favoriteButton.setText(this.getShortenedUrl(url));
            favoriteButton.setMenu(this.createFavoriteContextMenu(favoriteButton, url));
            this.favoritesBar.layout();
        }
        this.saveFavorites();
    }

    private String getShortenedUrl(String url) {
        try {
            URI uri = new URI(url);
            String domain = uri.getHost();
            String string = domain = domain.startsWith("www.") ? domain.substring(4) : domain;
            if (domain.length() > 20) {
                return domain.substring(0, 13) + "...";
            }
            return domain;
        }
        catch (Exception e) {
            if (url.length() > 15) {
                return url.substring(0, 13) + "...";
            }
            return url;
        }
    }

    private void saveFavorites() {
        String favoritesString = String.join((CharSequence)";", this.favorites);
        ConfigServiceHolder.setUser((String)BROWSER_FAVORIT_KEY, (String)favoritesString);
    }

    private void loadFavorites() {
        String favoritesString = ConfigServiceHolder.getUser((String)BROWSER_FAVORIT_KEY, (String)"");
        if (!favoritesString.isEmpty()) {
            String[] urls;
            String[] stringArray = urls = favoritesString.split(";");
            int n = urls.length;
            int n2 = 0;
            while (n2 < n) {
                String url = stringArray[n2];
                this.addFavorite(url);
                ++n2;
            }
        }
    }

    private Menu createFavoriteContextMenu(Button favoriteButton, String url) {
        Menu contextMenu = new Menu((Control)favoriteButton);
        MenuItem deleteItem = new MenuItem(contextMenu, 0);
        deleteItem.setText(Messages.Core_Delete_ellipsis);
        Image deleteImage = Images.IMG_FEHLER.getImage();
        deleteItem.setImage(deleteImage);
        deleteItem.addListener(13, e -> this.removeFavorite(url, favoriteButton));
        return contextMenu;
    }

    private void createAddressBarContextMenu() {
        Menu contextMenu = new Menu((Control)this.addressBarCombo);
        MenuItem clearHistoryItem = new MenuItem(contextMenu, 0);
        clearHistoryItem.setText(Messages.Web_History_Delete);
        clearHistoryItem.addListener(13, e -> this.clearHistory());
        this.addressBarCombo.setMenu(contextMenu);
    }

    private void clearHistory() {
        this.history.clear();
        this.addressBarCombo.removeAll();
        ConfigServiceHolder.setUser((String)BROWSER_HISTORY_KEY, null);
        this.currentHistoryIndex = -1;
    }

    private void removeFavorite(String url, Button favoriteButton) {
        this.favorites.remove(url);
        favoriteButton.dispose();
        this.favoritesBar.layout();
        this.saveFavorites();
    }

    private boolean isValidUrl(String url) {
        if (url.matches("^(http|https)://.*")) {
            try {
                new URL(url).toURI();
                return true;
            }
            catch (Exception e) {
                return false;
            }
        }
        return url.matches("[a-zA-Z0-9.-]+\\.[a-zA-Z]{2,}");
    }

    private String normalizeUrl(String url) {
        if (!url.matches("^(http|https)://.*")) {
            return "https://" + url;
        }
        return url;
    }

    private String encodeURIComponent(String component) {
        try {
            return URLEncoder.encode(component, StandardCharsets.UTF_8.toString());
        }
        catch (UnsupportedEncodingException e) {
            return component;
        }
    }

    private Button createButton(Composite parent, Image image, String toolTip, Consumer<Button> onClick) {
        return this.createButton(parent, image, toolTip, onClick, null);
    }

    private Button createButton(Composite parent, Image image, String toolTip, Consumer<Button> onClick, Object layoutData) {
        Button button = new Button(parent, 8);
        button.setImage(image);
        if (toolTip != null && !toolTip.isEmpty()) {
            button.setToolTipText(toolTip);
        }
        if (layoutData != null) {
            button.setLayoutData(layoutData);
        }
        button.addListener(13, e -> onClick.accept(button));
        return button;
    }

    private void loadUrlOrSearch(String enteredText) {
        Object urlToLoad;
        Object object = urlToLoad = this.isValidUrl(enteredText) ? this.normalizeUrl(enteredText) : SEARCH_ENGINE_URL + this.encodeURIComponent(enteredText);
        if (this.isUrlReachable((String)urlToLoad)) {
            this.browser.setUrl((String)urlToLoad);
            this.updateHistory((String)urlToLoad);
        } else {
            this.browser.setUrl(SEARCH_ENGINE_URL + this.encodeURIComponent(enteredText));
        }
    }

    private boolean isUrlReachable(String urlString) {
        try {
            URL url = new URL(urlString);
            HttpURLConnection urlConn = (HttpURLConnection)url.openConnection();
            urlConn.setConnectTimeout(1000);
            urlConn.setReadTimeout(1500);
            urlConn.connect();
            return urlConn.getResponseCode() >= 200 && urlConn.getResponseCode() < 300;
        }
        catch (IOException e) {
            return false;
        }
    }
}

