/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.preferences;

import ch.elexis.core.model.IXid;
import ch.elexis.core.services.IXidService;
import ch.elexis.core.services.holder.XidServiceHolder;
import ch.elexis.core.ui.preferences.Messages;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.core.ui.util.viewers.CommonViewer;
import ch.elexis.data.Organisation;
import ch.elexis.data.Person;
import ch.elexis.data.Xid;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class XIDEdit
extends PreferencePage
implements IWorkbenchPreferencePage {
    Table table;
    TableViewer tv;
    XIDComparator comparator;
    CommonViewer XIDViewer;
    IXidService xidService;

    public void init(IWorkbench workbench) {
        this.comparator = new XIDComparator();
        this.xidService = XidServiceHolder.get();
    }

    protected Control createContents(Composite parent) {
        this.tv = new TableViewer(parent, 68354);
        final Table table = this.tv.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        table.setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, true));
        table.setHeaderVisible(true);
        this.tv.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        HashSet<XIDRow> input = new HashSet<XIDRow>();
        List domains = this.xidService.getDomains();
        for (IXidService.IXidDomain dom : domains) {
            input.add(new XIDRow(dom));
        }
        this.tv.setInput(input);
        TableViewerColumn colviewShortName = new TableViewerColumn(this.tv, 0);
        TableColumn colShortName = colviewShortName.getColumn();
        colShortName.setWidth(200);
        colShortName.setText(Messages.XIDEdit_ShortName);
        colShortName.addSelectionListener((SelectionListener)this.getSelectionAdapter(colShortName, 0));
        colviewShortName.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                XIDRow xid = (XIDRow)element;
                return xid.getDomainSimpleName();
            }
        });
        TableViewerColumn domName = new TableViewerColumn(this.tv, 0);
        TableColumn domNameCol = domName.getColumn();
        domNameCol.setWidth(300);
        domNameCol.setText(Messages.XIDEdit_DomainName);
        domNameCol.addSelectionListener((SelectionListener)this.getSelectionAdapter(domNameCol, 1));
        domName.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                XIDRow xid = (XIDRow)element;
                return xid.getDomainName();
            }
        });
        TableViewerColumn disp = new TableViewerColumn(this.tv, 0);
        TableColumn dispCol = disp.getColumn();
        dispCol.setWidth(50);
        dispCol.setText(Messages.Core_Display);
        dispCol.addSelectionListener((SelectionListener)this.getSelectionAdapter(dispCol, 2));
        disp.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                XIDRow xid = (XIDRow)element;
                return xid.getDisplayedFor();
            }
        });
        this.tv.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = XIDEdit.this.tv.getStructuredSelection();
                if (!selection.isEmpty()) {
                    XIDRow id = (XIDRow)selection.getFirstElement();
                    if (selection.getFirstElement() instanceof IXid) {
                        id.getDomainName();
                        XIDEdit.this.tv.refresh();
                    }
                }
            }
        });
        table.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                TableItem[] sel = table.getSelection();
                if (sel != null && sel.length > 0) {
                    XIDRow selDom = (XIDRow)sel[0].getData();
                    new XidEditDialog(XIDEdit.this.getShell(), selDom).open();
                    TableItem[] tableItemArray = table.getItems();
                    int n = tableItemArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        TableItem it = tableItemArray[n2];
                        XIDRow xidRow = (XIDRow)it.getData();
                        it.setText(2, xidRow.getDisplayedFor());
                        ++n2;
                    }
                    table.redraw();
                }
            }
        });
        this.tv.setComparator((ViewerComparator)this.comparator);
        this.tv.refresh();
        return table;
    }

    private SelectionAdapter getSelectionAdapter(final TableColumn column, final int index) {
        SelectionAdapter selectionAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                XIDEdit.this.comparator.setColumn(index);
                XIDEdit.this.comparator.changeDirection();
                int dir = XIDEdit.this.comparator.getDirection();
                XIDEdit.this.tv.getTable().setSortDirection(dir);
                XIDEdit.this.tv.getTable().setSortColumn(column);
                XIDEdit.this.tv.refresh();
            }
        };
        return selectionAdapter;
    }

    public class XIDComparator
    extends ViewerComparator {
        private int propertyIndex;
        private int direction = 1;

        public int getDirection() {
            return this.direction == 1 ? 1024 : 128;
        }

        public void changeDirection() {
            this.direction *= -1;
        }

        public void setColumn(int column) {
            this.propertyIndex = column;
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            XIDRow row1 = (XIDRow)e1;
            XIDRow row2 = (XIDRow)e2;
            int rc = 0;
            switch (this.propertyIndex) {
                case 0: {
                    rc = Objects.compare(row1.getDomainSimpleName(), row2.getDomainSimpleName(), Comparator.nullsFirst(Comparator.naturalOrder())) * this.direction;
                    break;
                }
                case 1: {
                    rc = Objects.compare(row1.getDomainName(), row2.getDomainName(), Comparator.nullsFirst(Comparator.naturalOrder())) * this.direction;
                    break;
                }
                case 2: {
                    rc = Objects.compare(row1.getDisplayedFor(), row2.getDisplayedFor(), Comparator.nullsFirst(Comparator.naturalOrder())) * this.direction;
                    break;
                }
                default: {
                    rc = 0;
                }
            }
            return rc;
        }
    }

    static class XIDRow {
        public static final String DISPLAY_FOR_PERSON = "P";
        public static final String DISPLAY_FOR_ORG = "O";
        private IXidService.IXidDomain domain;

        public XIDRow(IXidService.IXidDomain xdom) {
            this.domain = xdom;
        }

        public String getDomainName() {
            return this.domain.getDomainName();
        }

        public String getDomainSimpleName() {
            return this.domain.getSimpleName();
        }

        public String getDisplayedFor() {
            Xid.XIDDomain xidDomain = Xid.getDomain((String)this.getDomainName());
            StringBuffer sb = new StringBuffer();
            if (xidDomain.isDisplayedFor(Person.class)) {
                sb.append(DISPLAY_FOR_PERSON);
            }
            if (xidDomain.isDisplayedFor(Organisation.class)) {
                sb.append(DISPLAY_FOR_ORG);
            }
            return sb.toString();
        }
    }

    static class XidEditDialog
    extends Dialog {
        Text tShort;
        Button bPerson;
        Button bOrg;
        Xid.XIDDomain mine;

        public XidEditDialog(Shell shell, XIDRow xidDom) {
            super(shell);
            this.mine = Xid.getDomain((String)xidDom.getDomainName());
        }

        public void create() {
            super.create();
            this.getShell().setText(Messages.XIDEdit_XidOpetions);
        }

        protected Control createDialogArea(Composite parent) {
            Composite ret = (Composite)super.createDialogArea(parent);
            ret.setLayout((Layout)new RowLayout(512));
            new Label(ret, 0).setText(this.mine.getDomainName());
            this.tShort = new Text(ret, 2048);
            this.tShort.setText(this.mine.getSimpleName());
            new Label(ret, 258);
            new Label(ret, 0).setText(Messages.XIDEdit_ShowWith);
            this.bPerson = new Button(ret, 32);
            this.bOrg = new Button(ret, 32);
            this.bPerson.setText(Messages.XIDEdit_Persons);
            this.bOrg.setText(Messages.XIDEdit_Organizations);
            this.bPerson.setSelection(false);
            this.bOrg.setSelection(false);
            if (this.mine.isDisplayedFor(Person.class)) {
                this.bPerson.setSelection(true);
            }
            if (this.mine.isDisplayedFor(Organisation.class)) {
                this.bOrg.setSelection(true);
            }
            return ret;
        }

        protected void okPressed() {
            if (this.bPerson.getSelection()) {
                this.mine.addDisplayOption(Person.class);
            } else {
                this.mine.removeDisplayOption(Person.class);
            }
            if (this.bOrg.getSelection()) {
                this.mine.addDisplayOption(Organisation.class);
            } else {
                this.mine.removeDisplayOption(Organisation.class);
            }
            this.mine.setSimpleName(this.tShort.getText());
            super.okPressed();
        }
    }
}

