/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.preferences;

import ch.elexis.core.model.Deleteable;
import ch.elexis.core.model.ICoverage;
import ch.elexis.core.model.IDocumentLetter;
import ch.elexis.core.model.IEncounter;
import ch.elexis.core.model.IImage;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.model.ISticker;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.services.holder.CoreModelServiceHolder;
import ch.elexis.core.services.holder.StickerServiceHolder;
import ch.elexis.core.services.holder.StoreToStringServiceHolder;
import ch.elexis.core.ui.UiDesk;
import ch.elexis.core.ui.data.UiDBImage;
import ch.elexis.core.ui.dialogs.ImageChooser;
import ch.elexis.core.ui.e4.util.CoreUiUtil;
import ch.elexis.core.ui.preferences.Messages;
import ch.elexis.core.ui.util.SWTHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class Stickers
extends PreferencePage
implements IWorkbenchPreferencePage {
    ComboViewer comboViewer;
    Canvas cImage;
    Canvas cFore;
    Canvas cBack;
    ISticker act;
    List<ISticker> lEtiketten;
    Button bNew;
    Button bRemove;
    Spinner spWert;
    HashMap<String, Button> classesCheck = new HashMap();

    void setSticker(ISticker et) {
        this.act = et;
        if (et == null) {
            this.cImage.setBackground(UiDesk.getColor("weiss"));
            this.cFore.setBackground(UiDesk.getColor("schwarz"));
            this.cBack.setBackground(UiDesk.getColor("hellgrau"));
            this.spWert.setSelection(0);
        } else {
            this.cFore.setBackground(CoreUiUtil.getColorForString((String)this.act.getForeground()));
            this.cBack.setBackground(CoreUiUtil.getColorForString((String)this.act.getBackground()));
            this.spWert.setSelection(this.act.getImportance());
            List classes = StickerServiceHolder.get().getStickerClassLinksForSticker(this.act);
            for (Map.Entry<String, Button> e : this.classesCheck.entrySet()) {
                e.getValue().setSelection(false);
            }
            for (String st : classes) {
                Button b = this.classesCheck.get(st);
                if (b == null) continue;
                b.setSelection(true);
            }
        }
        this.cImage.redraw();
        this.cFore.redraw();
        this.cBack.redraw();
    }

    protected Control createContents(Composite parent) {
        Composite ret = new Composite(parent, 0);
        ret.setLayout((Layout)new GridLayout());
        ret.setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, true));
        this.comboViewer = new ComboViewer(ret, 64);
        this.comboViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.comboViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof ISticker) {
                    return ((ISticker)element).getName();
                }
                return super.getText(element);
            }
        });
        this.comboViewer.getControl().setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, true));
        this.comboViewer.addSelectionChangedListener(e -> {
            if (!e.getStructuredSelection().isEmpty()) {
                this.setSticker((ISticker)e.getStructuredSelection().getFirstElement());
                this.bRemove.setEnabled(true);
            }
        });
        this.comboViewer.getCombo().addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (Stickers.this.comboViewer.getCombo().getText().length() == 0) {
                    Stickers.this.bNew.setEnabled(false);
                } else {
                    Stickers.this.bNew.setEnabled(true);
                }
            }
        });
        this.comboViewer.setInput(this.lEtiketten);
        Composite bottom = new Composite(ret, 0);
        bottom.setLayout((Layout)new GridLayout(3, false));
        this.bNew = new Button(bottom, 8);
        this.bNew.setText(Messages.Stickers_NewSticker);
        this.bNew.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String name = Stickers.this.comboViewer.getCombo().getText();
                ISticker sticker = (ISticker)CoreModelServiceHolder.get().create(ISticker.class);
                sticker.setName(name);
                sticker.setForeground("000000");
                sticker.setBackground("ffffff");
                CoreModelServiceHolder.get().save((Identifiable)sticker);
                Stickers.this.lEtiketten.add(sticker);
                Stickers.this.comboViewer.setInput(Stickers.this.lEtiketten);
                Stickers.this.comboViewer.setSelection((ISelection)new StructuredSelection((Object)sticker));
                Stickers.this.setSticker(sticker);
            }
        });
        this.bRemove = new Button(bottom, 8);
        this.bRemove.setText(Messages.Stickers_DeleteSticker);
        this.bRemove.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = Stickers.this.comboViewer.getStructuredSelection();
                if (selection != null && !selection.isEmpty()) {
                    ISticker eti = (ISticker)selection.getFirstElement();
                    Stickers.this.lEtiketten.remove(eti);
                    Stickers.this.comboViewer.setInput(Stickers.this.lEtiketten);
                    CoreModelServiceHolder.get().delete((Deleteable)eti);
                    Stickers.this.setSticker(null);
                }
            }
        });
        Group bottomRight = new Group(bottom, 0);
        bottomRight.setLayoutData((Object)SWTHelper.getFillGridData(1, true, 5, true));
        bottomRight.setLayout((Layout)new RowLayout(512));
        bottomRight.setText(Messages.Stickers_useFor);
        this.addAssociateButton(Messages.Core_Patient, IPatient.class, (Composite)bottomRight);
        this.addAssociateButton(Messages.Core_Consultation, IEncounter.class, (Composite)bottomRight);
        this.addAssociateButton(Messages.Core_Case, ICoverage.class, (Composite)bottomRight);
        this.addAssociateButton(Messages.Core_Document, IDocumentLetter.class, (Composite)bottomRight);
        bottom.setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, false));
        this.cImage = new Canvas(bottom, 2048);
        this.cImage.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                GC gc = e.gc;
                if (Stickers.this.act != null) {
                    Image img;
                    Image image = img = Stickers.this.act.getImage() != null ? CoreUiUtil.getImageAsIcon((IImage)Stickers.this.act.getImage()) : null;
                    if (img != null) {
                        gc.drawImage(img, 0, 0);
                        return;
                    }
                }
                gc.setForeground(UiDesk.getColor("grau20"));
                gc.fillRectangle(0, 0, 32, 32);
            }
        });
        GridData gdImage = new GridData(32, 32);
        this.cImage.setLayoutData((Object)gdImage);
        Button bNewImage = new Button(bottom, 8);
        bNewImage.setText(Messages.Stickers_Image);
        bNewImage.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ImageChooser imc;
                if (Stickers.this.act != null && (imc = new ImageChooser(Stickers.this.getShell())).open() == 0) {
                    UiDBImage dbImage = imc.getSelection();
                    if (dbImage != null) {
                        Stickers.this.act.setImage((IImage)CoreModelServiceHolder.get().load(dbImage.getId(), IImage.class).get());
                    } else {
                        Stickers.this.act.setImage(null);
                    }
                    CoreModelServiceHolder.get().save((Identifiable)Stickers.this.act);
                    Stickers.this.setSticker(Stickers.this.act);
                }
            }
        });
        this.cFore = new Canvas(bottom, 2048);
        GridData gdFore = new GridData(32, 16);
        this.cFore.setLayoutData((Object)gdFore);
        Button bFore = new Button(bottom, 8);
        bFore.setText(Messages.Core_TextColour);
        bFore.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (Stickers.this.act != null) {
                    ColorDialog cd = new ColorDialog(Stickers.this.getShell(), 0);
                    RGB rgb = cd.open();
                    if (rgb != null) {
                        Stickers.this.act.setForeground(UiDesk.createColor(rgb));
                        CoreModelServiceHolder.get().save((Identifiable)Stickers.this.act);
                    }
                    Stickers.this.setSticker(Stickers.this.act);
                }
            }
        });
        this.cBack = new Canvas(bottom, 2048);
        GridData gdBack = GridDataFactory.copyData((GridData)gdFore);
        this.cBack.setLayoutData((Object)gdBack);
        Button bBack = new Button(bottom, 8);
        bBack.setText(Messages.Stickers_BackgroundColor);
        bBack.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (Stickers.this.act != null) {
                    ColorDialog cd = new ColorDialog(Stickers.this.getShell(), 0);
                    RGB rgb = cd.open();
                    if (rgb != null) {
                        Stickers.this.act.setBackground(UiDesk.createColor(rgb));
                        CoreModelServiceHolder.get().save((Identifiable)Stickers.this.act);
                    }
                    Stickers.this.setSticker(Stickers.this.act);
                }
            }
        });
        this.spWert = new Spinner(bottom, 0);
        this.spWert.setMaximum(999);
        this.spWert.setMinimum(0);
        this.spWert.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (Stickers.this.act != null) {
                    Stickers.this.act.setImportance(Stickers.this.spWert.getSelection());
                    CoreModelServiceHolder.get().save((Identifiable)Stickers.this.act);
                }
            }
        });
        new Label(bottom, 0).setText(Messages.Stickers_ValueOfSticker);
        this.bNew.setEnabled(false);
        this.bRemove.setEnabled(false);
        return ret;
    }

    public void init(IWorkbench workbench) {
        this.lEtiketten = CoreModelServiceHolder.get().getQuery(ISticker.class).execute();
        this.lEtiketten = new ArrayList<ISticker>(this.lEtiketten.stream().filter(et -> et.isVisible() && et.getImportance() < 1000).toList());
    }

    private void addAssociateButton(String label, final Class<?> clazz, Composite parent) {
        final Button button = new Button(parent, 32);
        button.setText(label);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = Stickers.this.comboViewer.getStructuredSelection();
                if (selection != null && !selection.isEmpty()) {
                    ISticker sticker = (ISticker)selection.getFirstElement();
                    if (button.getSelection()) {
                        StickerServiceHolder.get().setStickerAddableToClass(clazz, sticker);
                    } else {
                        StickerServiceHolder.get().removeStickerAddableToClass(clazz, sticker);
                    }
                }
            }
        });
        this.classesCheck.put(StoreToStringServiceHolder.get().getTypeForModel(clazz), button);
    }
}

