/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.preferences;

import ch.elexis.core.services.holder.ConfigServiceHolder;
import ch.elexis.core.ui.UiDesk;
import ch.elexis.core.ui.dialogs.KontaktSelektor;
import ch.elexis.core.ui.preferences.Messages;
import ch.elexis.core.ui.util.LabeledInputField;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.data.Kontakt;
import ch.elexis.data.Mandant;
import ch.elexis.data.PersistentObject;
import ch.elexis.data.Query;
import ch.elexis.data.Rechnungssteller;
import java.util.Hashtable;
import java.util.List;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class Mandanten
extends PreferencePage
implements IWorkbenchPreferencePage {
    private LabeledInputField.AutoForm lfa;
    private LabeledInputField.InputData[] def;
    private Label lColor;
    private Hashtable<String, Mandant> hMandanten = new Hashtable();

    protected Control createContents(Composite parent) {
        FormToolkit tk = UiDesk.getToolkit();
        Form form = tk.createForm(parent);
        Composite body = form.getBody();
        body.setLayout((Layout)new GridLayout(1, false));
        final Combo mandanten = new Combo(body, 12);
        Query qbe = new Query(Mandant.class);
        List list = qbe.execute();
        for (Mandant m : list) {
            mandanten.add(m.getLabel());
            this.hMandanten.put(m.getLabel(), m);
        }
        mandanten.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Combo source = (Combo)e.getSource();
                String m = source.getItem(source.getSelectionIndex());
                Mandant man = Mandanten.this.hMandanten.get(m);
                Mandanten.this.lColor.setBackground(UiDesk.getColorFromRGB(ConfigServiceHolder.getGlobal((String)("mandanten/farben/" + m), (String)"grau60")));
                Mandanten.this.lfa.reload((PersistentObject)man);
            }
        });
        GridData gd = new GridData(768);
        mandanten.setLayoutData((Object)gd);
        tk.adapt((Composite)mandanten);
        this.lfa = new LabeledInputField.AutoForm(body, this.def);
        this.lfa.setLayoutData(SWTHelper.getFillGridData(1, true, 1, true));
        this.lColor = new Label(body, 0);
        this.lColor.setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, false));
        this.lColor.setText("Color for mandator");
        this.lColor.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                ColorDialog cd = new ColorDialog(Mandanten.this.getShell());
                Label l = (Label)e.getSource();
                RGB selected = cd.open();
                String symbolic = UiDesk.createColor(selected);
                l.setBackground(UiDesk.getColorFromRGB(symbolic));
                ConfigServiceHolder.setGlobal((String)("mandanten/farben/" + mandanten.getItem(mandanten.getSelectionIndex())), (String)symbolic);
            }
        });
        tk.paintBordersFor(body);
        return form;
    }

    public void init(IWorkbench workbench) {
        String grp = ConfigServiceHolder.getGlobal((String)"groupNames", (String)Messages.Core_Admin);
        this.def = new LabeledInputField.InputData[]{new LabeledInputField.InputData(Messages.Core_Short_Label, "Label", LabeledInputField.InputData.Typ.STRING, null), new LabeledInputField.InputData(Messages.Core_Password, "ExtInfo", LabeledInputField.InputData.Typ.STRING, "UsrPwd"), new LabeledInputField.InputData(Messages.Core_Groups, "ExtInfo", "Groups", grp.split(",")), new LabeledInputField.InputData(Messages.Core_Invoicingparty, "ExtInfo", new LabeledInputField.IContentProvider(){

            @Override
            public void displayContent(Object po, LabeledInputField.InputData ltf) {
                Mandant m = (Mandant)po;
                Rechnungssteller r = m.getRechnungssteller();
                ltf.setText(r.getLabel());
            }

            @Override
            public void reloadContent(Object po, LabeledInputField.InputData ltf) {
                Kontakt rsi = (Kontakt)po;
                KontaktSelektor ksl = new KontaktSelektor(Mandanten.this.getShell(), Kontakt.class, Messages.Mandanten_selectBiller, Messages.Mandanten_pleaseSelectBiller, new String[]{"Bezeichnung1", "Bezeichnung2"});
                if (ksl.open() == 0) {
                    rsi = (Kontakt)ksl.getSelection();
                }
                ((Mandant)po).setRechnungssteller(rsi);
                ltf.setText(rsi.getLabel());
            }
        })};
    }
}

