/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.locks;

import ch.elexis.core.ac.EvaluatableACE;
import ch.elexis.core.data.service.LocalLockServiceHolder;
import ch.elexis.core.services.holder.AccessControlServiceHolder;
import ch.elexis.core.ui.actions.RestrictedAction;

public abstract class LockedRestrictedAction<T>
extends RestrictedAction {
    private T object;

    public LockedRestrictedAction(EvaluatableACE requiredACE, String text) {
        super(requiredACE, text);
        this.setEnabled(false);
    }

    @Override
    public void reflectRight() {
        this.setEnabled(false);
        boolean rights = AccessControlServiceHolder.get().evaluate(this.evaluatableAce);
        if (!rights) {
            return;
        }
        this.object = this.getTargetedObject();
        if (this.object == null) {
            return;
        }
        this.setEnabled(LocalLockServiceHolder.get().isLocked(this.object));
    }

    @Override
    public void doRun() {
        if (LocalLockServiceHolder.get().isLocked(this.object) && AccessControlServiceHolder.get().evaluate(this.evaluatableAce) && this.object != null) {
            this.doRun(this.object);
        }
    }

    public abstract T getTargetedObject();

    public abstract void doRun(T var1);
}

