/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.dialogs;

import ch.elexis.core.l10n.Messages;
import ch.rgw.tools.Result;
import java.util.StringJoiner;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class ResultDialog {
    public static void show(Result<?> result) {
        if (!result.getMessages().isEmpty()) {
            if (result.isOK()) {
                ResultDialog.showInfo(result);
            } else if (ResultDialog.isWarnining(result)) {
                ResultDialog.showWarninig(result);
            } else {
                ResultDialog.showError(result);
            }
        }
    }

    private static boolean isWarnining(Result<?> result) {
        for (Result.msg message : result.getMessages()) {
            if (message.getSeverity() == Result.SEVERITY.WARNING) continue;
            return false;
        }
        return true;
    }

    private static void showError(Result<?> result) {
        MessageDialog.openError((Shell)ResultDialog.getShell(), (String)Messages.Core_Error, (String)ResultDialog.getResultMessage(result));
    }

    private static void showWarninig(Result<?> result) {
        MessageDialog.openWarning((Shell)ResultDialog.getShell(), (String)Messages.Core_Warning, (String)ResultDialog.getResultMessage(result));
    }

    private static void showInfo(Result<?> result) {
        MessageDialog.openInformation((Shell)ResultDialog.getShell(), (String)Messages.Core_Information, (String)ResultDialog.getResultMessage(result));
    }

    public static String getResultMessage(Result<?> result) {
        StringJoiner sj = new StringJoiner("\n\n");
        for (Result.msg message : result.getMessages()) {
            sj.add(message.getText());
        }
        return sj.toString();
    }

    private static Shell getShell() {
        return Display.getDefault().getActiveShell();
    }
}

