/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.dialogs;

import ch.elexis.core.model.IArticle;
import ch.elexis.core.model.IMandator;
import ch.elexis.core.model.IOrder;
import ch.elexis.core.services.IOrderService;
import ch.elexis.core.services.holder.ContextServiceHolder;
import ch.elexis.core.services.holder.CoreModelServiceHolder;
import ch.elexis.core.ui.dialogs.Messages;
import ch.elexis.core.ui.e4.providers.IdentifiableLabelProvider;
import ch.elexis.core.ui.e4.util.CoreUiUtil;
import ch.elexis.core.ui.util.SWTHelper;
import ch.rgw.tools.TimeTool;
import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.nebula.widgets.cdatetime.CDateTime;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.dialogs.ListSelectionDialog;

public class DailyConsumptionOrderDialog
extends TitleAreaDialog {
    private CDateTime dtDate;
    private TableViewer tableViewer;
    private IOrder currOrder;
    private TimeTool selectedDate;
    private Map<IArticle, Integer> diffEntries = new LinkedHashMap<IArticle, Integer>();
    private List<IMandator> limitationList = new ArrayList<IMandator>();
    private Map<IArticle, Integer> tempEntries = new LinkedHashMap<IArticle, Integer>();
    @Inject
    private IOrderService orderService;

    public DailyConsumptionOrderDialog(Shell parentShell, IOrder currOrder) {
        super(parentShell);
        this.currOrder = currOrder;
        CoreUiUtil.injectServices((Object)((Object)this));
    }

    public void create() {
        super.create();
        this.setTitle(Messages.DailyOrderDialog_Title);
        this.setMessage(Messages.DailyOrderDialog_Message);
    }

    protected boolean isResizable() {
        return true;
    }

    protected Control createDialogArea(Composite parent) {
        Composite area = new Composite(parent, 0);
        area.setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, true));
        area.setLayout((Layout)new GridLayout(1, false));
        Composite dateComposite = new Composite(area, 0);
        dateComposite.setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, false));
        dateComposite.setLayout((Layout)new GridLayout(2, false));
        this.dtDate = new CDateTime(dateComposite, 0x200802);
        this.dtDate.setSelection(new Date());
        this.selectedDate = new TimeTool(this.dtDate.getSelection());
        this.dtDate.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DailyConsumptionOrderDialog.this.selectedDate = new TimeTool(DailyConsumptionOrderDialog.this.dtDate.getSelection());
                DailyConsumptionOrderDialog.this.updateTempEntries();
                DailyConsumptionOrderDialog.this.diffEntries.clear();
                DailyConsumptionOrderDialog.this.diffEntries = DailyConsumptionOrderDialog.this.orderService.calculateDailyDifferences(DailyConsumptionOrderDialog.this.selectedDate.toLocalDate(), DailyConsumptionOrderDialog.this.limitationList);
                DailyConsumptionOrderDialog.this.tableViewer.setInput(DailyConsumptionOrderDialog.this.diffEntries.entrySet().stream().filter(entry -> (Integer)entry.getValue() != 0).collect(Collectors.toList()));
            }
        });
        final Button btnFilterMandators = new Button(dateComposite, 32);
        btnFilterMandators.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        btnFilterMandators.setText("nur von folgenden Mandanten ...");
        btnFilterMandators.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DailyConsumptionOrderDialog.this.limitationList.clear();
                btnFilterMandators.setText("nur von folgenden Mandanten ...");
                if (btnFilterMandators.getSelection()) {
                    ListSelectionDialog lsd = new ListSelectionDialog(Display.getDefault().getActiveShell(), (Object)CoreModelServiceHolder.get().getQuery(IMandator.class).execute(), (IStructuredContentProvider)ArrayContentProvider.getInstance(), (ILabelProvider)IdentifiableLabelProvider.getInstance(), Messages.DailyOrderMandant);
                    int open = lsd.open();
                    if (open == 0) {
                        DailyConsumptionOrderDialog.this.limitationList.addAll(Arrays.asList(lsd.getResult()).stream().map(m -> (IMandator)m).collect(Collectors.toList()));
                        String label = Messages.DailyOrderMandantOnlyFollowing + DailyConsumptionOrderDialog.this.limitationList.stream().map(m -> m.getLabel()).reduce((u, t) -> u + ", " + t).orElse(Messages.DailyOrderMandantNone);
                        btnFilterMandators.setText(label);
                        DailyConsumptionOrderDialog.this.updateTempEntries();
                        DailyConsumptionOrderDialog.this.tableViewer.setInput(DailyConsumptionOrderDialog.this.tempEntries.entrySet());
                    } else {
                        btnFilterMandators.setSelection(false);
                    }
                }
            }
        });
        Composite tableComposite = new Composite(area, 0);
        tableComposite.setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, true));
        TableColumnLayout tcLayout = new TableColumnLayout();
        tableComposite.setLayout((Layout)tcLayout);
        this.tableViewer = new TableViewer(tableComposite, 67584);
        Table table = this.tableViewer.getTable();
        table.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        TableViewerColumn colAmount = new TableViewerColumn(this.tableViewer, 0);
        TableColumn tcAmount = colAmount.getColumn();
        tcAmount.setText(Messages.Core_Number);
        tcLayout.setColumnData((Widget)tcAmount, (ColumnLayoutData)new ColumnPixelData(70, false));
        colAmount.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof Map.Entry) {
                    Map.Entry entry = (Map.Entry)element;
                    return String.valueOf(entry.getValue());
                }
                return "";
            }

            public Color getForeground(Object element) {
                Map.Entry entry;
                int value;
                if (element instanceof Map.Entry && (value = ((Integer)(entry = (Map.Entry)element).getValue()).intValue()) < 0) {
                    return Display.getCurrent().getSystemColor(3);
                }
                return super.getForeground(element);
            }
        });
        TableViewerColumn colArticle = new TableViewerColumn(this.tableViewer, 0);
        TableColumn tcArticle = colArticle.getColumn();
        tcArticle.setText(Messages.Core_Article);
        tcLayout.setColumnData((Widget)tcArticle, (ColumnLayoutData)new ColumnPixelData(300, true));
        colArticle.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                Map.Entry entry;
                Object k;
                if (element instanceof Map.Entry && (k = (entry = (Map.Entry)element).getKey()) instanceof IArticle) {
                    IArticle art = (IArticle)k;
                    return art.getLabel();
                }
                return "";
            }
        });
        this.tableViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.updateTempEntries();
        this.diffEntries.clear();
        this.diffEntries = this.orderService.calculateDailyDifferences(this.selectedDate.toLocalDate(), this.limitationList);
        this.tableViewer.setInput(this.diffEntries.entrySet().stream().filter(entry -> (Integer)entry.getValue() != 0).collect(Collectors.toList()));
        return area;
    }

    private void updateTempEntries() {
        this.tempEntries.clear();
        this.tempEntries.putAll(this.orderService.calculateDailyConsumption(this.selectedDate.toLocalDate(), this.limitationList));
    }

    protected void okPressed() {
        Optional mandator = ContextServiceHolder.get().getActiveMandator();
        if (this.orderService != null) {
            Map toCreate = this.diffEntries.entrySet().stream().filter(e -> (Integer)e.getValue() > 0).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (a, b) -> b, LinkedHashMap::new));
            Map toReduce = this.diffEntries.entrySet().stream().filter(e -> (Integer)e.getValue() < 0).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (a, b) -> b, LinkedHashMap::new));
            List relevantOrders = this.orderService.findOpenOrdersByDate(this.selectedDate.toLocalDate());
            this.orderService.addOrCreateOrderEntries(relevantOrders, this.currOrder, toCreate, (IMandator)mandator.orElse(null));
            toReduce.forEach((article, amount) -> this.orderService.reduceOpenEntries(relevantOrders, article, -amount.intValue()));
        }
        super.okPressed();
    }

    public IOrder getOrder() {
        return this.currOrder;
    }

    protected void cancelPressed() {
        super.cancelPressed();
    }
}

