/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.scripting;

import ch.elexis.core.status.ElexisStatus;
import ch.elexis.core.ui.Hub;
import ch.elexis.data.Fall;
import ch.elexis.data.Konsultation;
import ch.elexis.data.Patient;
import ch.elexis.data.Query;
import ch.elexis.scripting.CSVWriter;
import ch.elexis.scripting.ScriptingException;
import java.io.File;
import java.io.FileWriter;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.swt.widgets.FileDialog;

public class Stammdatenexport {
    public String doExport(String startDate) {
        FileDialog out = new FileDialog(Hub.getActiveShell(), 8192);
        out.setFilterExtensions(new String[]{"*.csv"});
        out.setFilterNames(new String[]{"Comma Separated Values (CVS)"});
        out.setOverwrite(true);
        String file = out.open();
        if (file != null) {
            try {
                FileWriter writer = new FileWriter(new File(file));
                CSVWriter csv = new CSVWriter(writer);
                String[] header = new String[]{"UUID", "Nr", "Titel", "Name", "Vorname", "Geschlecht", "Geburtsdatum", "Strasse", "Plz", "Ort", "Postanschrift", "Telefon 1", "Telefon 2", "Telefon Mobil", "Bemerkung"};
                String[] fields = new String[]{"ID", "PatientNr", "Titel", "Name", "Vorname", "Geschlecht", "Geburtsdatum", "Strasse", "Plz", "Ort", "Anschrift", "Telefon1", "Telefon2", "Natel", "Bemerkung"};
                csv.writeNext(header);
                if (startDate == null || startDate.length() == 0) {
                    for (Patient pat : new Query(Patient.class).execute()) {
                        String[] line = new String[header.length];
                        int i = 0;
                        while (i < header.length) {
                            line[i] = pat.get(fields[i]);
                            ++i;
                        }
                        csv.writeNext(line);
                    }
                } else {
                    HashMap<Patient, String> patienten = new HashMap<Patient, String>();
                    Query qbe = new Query(Konsultation.class);
                    qbe.add("Datum", ">", startDate);
                    List lKons = qbe.execute();
                    for (Konsultation k : lKons) {
                        Fall fall = k.getFall();
                        Patient p = fall.getPatient();
                        patienten.put(p, "1");
                    }
                    for (Patient p : patienten.keySet()) {
                        String[] line = new String[header.length];
                        int i = 0;
                        while (i < header.length) {
                            line[i] = p.get(fields[i]);
                            ++i;
                        }
                        csv.writeNext(line);
                    }
                }
                csv.close();
                return "Der Export wurde efrolgreich abgeschlossen";
            }
            catch (Exception ex) {
                ElexisStatus status = new ElexisStatus(4, "ch.elexis.core.ui", 0, "Fehler beim Export: " + ex.getMessage(), ex);
                throw new ScriptingException((IStatus)status);
            }
        }
        return "Abbruch durch den Benutzer";
    }
}

