/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.util;

import ch.elexis.core.data.service.StoreToStringServiceHolder;
import ch.elexis.core.ui.actions.ICodeSelectorTarget;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Control;

public class GenericObjectDropTarget
implements DropTargetListener,
ICodeSelectorTarget {
    IReceiver rc;
    String name = "";
    private final Color normalColor;
    private final Color highlightColor;
    private final Control mine;

    public GenericObjectDropTarget(String name, Control target, IReceiver r, boolean colorizeControl) {
        if (colorizeControl) {
            this.normalColor = target.getBackground();
            this.highlightColor = target.getDisplay().getSystemColor(3);
        } else {
            this.normalColor = null;
            this.highlightColor = null;
        }
        this.name = name;
        this.mine = target;
        this.rc = r;
        DropTarget dtarget = new DropTarget(target, 1);
        TextTransfer textTransfer = TextTransfer.getInstance();
        Transfer[] types = new Transfer[]{textTransfer};
        dtarget.setTransfer(types);
        dtarget.addDropListener((DropTargetListener)this);
    }

    public GenericObjectDropTarget(Control target, IReceiver r) {
        this("", target, r, true);
    }

    public GenericObjectDropTarget(String name, Control target, IReceiver r) {
        this(name, target, r, true);
    }

    public void dragEnter(DropTargetEvent event) {
        boolean bOk = false;
        if (this.rc.accept(this.getDataObjects(event))) {
            bOk = true;
        }
        event.detail = bOk ? 1 : 0;
    }

    private List<Object> getDataObjects(DropTargetEvent event) {
        if (event != null && event.data != null) {
            String[] parts;
            ArrayList<Object> ret = new ArrayList<Object>();
            String droppedString = (String)event.data;
            String[] stringArray = parts = droppedString.split(",");
            int n = parts.length;
            int n2 = 0;
            while (n2 < n) {
                String part = stringArray[n2];
                Object loaded = StoreToStringServiceHolder.getLoadFromString((String)part);
                if (loaded != null) {
                    ret.add(loaded);
                }
                ++n2;
            }
            return ret;
        }
        return Collections.emptyList();
    }

    public void dragLeave(DropTargetEvent event) {
    }

    public void dragOperationChanged(DropTargetEvent event) {
    }

    public void dragOver(DropTargetEvent event) {
    }

    public void dropAccept(DropTargetEvent event) {
        if (!this.rc.accept(this.getDataObjects(event))) {
            event.detail = 0;
        }
    }

    @Override
    public void codeSelected(Object obj) {
        if (this.rc.accept(Collections.singletonList(obj))) {
            this.rc.dropped(Collections.singletonList(obj), null);
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void registered(boolean bIsRegistered) {
        if (this.normalColor != null) {
            this.highlight(bIsRegistered);
        }
    }

    private void highlight(boolean bOn) {
        Control highlightControl = this.getHighLightControl();
        if (!this.mine.isDisposed()) {
            if (bOn) {
                highlightControl.setBackground(this.highlightColor);
            } else {
                highlightControl.setBackground(this.normalColor);
            }
        }
    }

    protected Control getHighLightControl() {
        return this.mine;
    }

    public void drop(DropTargetEvent event) {
        this.rc.dropped(this.getDataObjects(event), event);
    }

    public static interface IReceiver {
        public void dropped(List<Object> var1, DropTargetEvent var2);

        public boolean accept(List<Object> var1);
    }
}

