/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.selectors;

import ch.elexis.core.ui.UiDesk;
import ch.elexis.core.ui.selectors.ActiveControlListener;
import ch.elexis.core.ui.util.SWTHelper;
import java.util.HashMap;
import java.util.LinkedList;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public abstract class ActiveControl
extends Composite {
    private Label lbl;
    protected Control ctl;
    protected Composite controllers;
    protected String textContents = "";
    private String labelContents = "";
    private LinkedList<ActiveControlListener> listeners;
    private HashMap<String, Object> properties = new HashMap();
    private int flags;
    public static final int HIDE_LABEL = 1;
    public static final int DISPLAY_HORIZONTAL = 2;
    public static final int LABEL_IS_HYPERLINK = 4;
    public static final int READONLY = 8;
    public static final int LINK_TO_DB = 16;
    public static final String PROP_DISPLAYNAME = "displayName";
    public static final String PROP_FIELDNAME = "fieldName";
    public static final String PROP_HASHNAME = "hashName";
    public static final String PROP_ERRMSG = "invalidContents";
    public static final String PROP_VALID_PATTERN = "validPattern";

    public ActiveControl(Composite parent, int displayBits, String displayName) {
        super(parent, 0);
        if ((displayBits & 3) == 2) {
            this.setLayout((Layout)new GridLayout(3, false));
        } else {
            this.setLayout((Layout)new GridLayout(2, false));
        }
        this.flags = displayBits;
        String string = this.labelContents = displayName == null ? "" : displayName;
        if ((displayBits & 1) == 0) {
            this.lbl = new Label((Composite)this, 0);
            this.lbl.setText(displayName);
            this.setData(PROP_DISPLAYNAME, displayName);
            this.controllers = new Composite((Composite)this, 0);
            GridData gd = new GridData(131072, 1024, false, false);
            Point size = this.lbl.computeSize(-1, -1);
            gd.heightHint = size.y;
            this.controllers.setLayoutData((Object)gd);
            this.controllers.setLayout((Layout)new FillLayout());
            this.lbl.setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, false));
        }
    }

    public void addListener(ActiveControlListener listen) {
        if (this.listeners == null) {
            this.listeners = new LinkedList();
        }
        this.listeners.add(listen);
    }

    public void removeSelectorListener(ActiveControlListener listen) {
        if (this.listeners != null) {
            this.listeners.remove(listen);
        }
    }

    public boolean isValid() {
        String validPattern = (String)this.properties.get(PROP_VALID_PATTERN);
        return validPattern == null || this.getText().matches(validPattern);
    }

    public boolean isReadonly() {
        return (this.flags & 8) == 8;
    }

    public void fireChangedEvent() {
        if (!this.isValid() && this.listeners != null) {
            for (ActiveControlListener sl : this.listeners) {
                sl.invalidContents(this);
            }
        }
        if (this.listeners != null) {
            for (ActiveControlListener sl : this.listeners) {
                sl.contentsChanged(this);
            }
        }
    }

    protected abstract void push();

    public void setText(String text) {
        this.textContents = text;
        this.push();
    }

    public String getText() {
        return this.textContents;
    }

    public void clear() {
        this.textContents = "";
        this.push();
    }

    public String getLabelText() {
        return this.labelContents;
    }

    public void setLabelText(final String text) {
        UiDesk.asyncExec(new Runnable(){

            @Override
            public void run() {
                ActiveControl.this.lbl.setText(text);
            }
        });
    }

    protected void setControl(Control control) {
        this.ctl = control;
        this.ctl.setLayoutData((Object)SWTHelper.getFillGridData(2, true, 1, false));
        this.ctl.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                ActiveControl.this.isValid();
            }
        });
    }

    public Control getCtl() {
        return this.ctl;
    }

    public String getDisplayName() {
        return (String)this.getData(PROP_DISPLAYNAME);
    }

    public void setDisplayName(String displayName) {
        this.setData(PROP_DISPLAYNAME, displayName);
        this.lbl.setText(displayName);
    }

    public void setEnabled(boolean bEnable) {
        if (this.ctl != null) {
            this.ctl.setEnabled(bEnable);
        }
    }

    public Composite getControllerComposite() {
        return this.controllers;
    }

    public void setData(String name, Object value) {
        this.properties.put(name, value);
    }

    public Object getData(String name) {
        return this.properties.get(name);
    }

    public String getProperty(String name) {
        return (String)this.getData(name);
    }

    public void setValidPattern(String pattern, String errmsg) {
        this.setData(PROP_VALID_PATTERN, pattern);
        this.setData(PROP_ERRMSG, errmsg);
    }

    public String getErrMsg() {
        return (String)this.properties.get(PROP_ERRMSG);
    }
}

