/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.locks;

import ch.elexis.core.ac.EvaluatableACE;
import ch.elexis.core.data.service.LocalLockServiceHolder;
import ch.elexis.core.lock.types.LockResponse;
import ch.elexis.core.services.holder.AccessControlServiceHolder;
import ch.elexis.core.ui.actions.RestrictedAction;
import ch.elexis.core.ui.locks.LockResponseHelper;

public abstract class LockRequestingRestrictedAction<T>
extends RestrictedAction {
    private T object;

    public LockRequestingRestrictedAction(EvaluatableACE necessaryRight, String text) {
        super(necessaryRight, text);
    }

    @Override
    public void doRun() {
        if (!AccessControlServiceHolder.get().evaluate(this.evaluatableAce)) {
            return;
        }
        this.object = this.getTargetedObject();
        if (this.object == null) {
            return;
        }
        LockResponse lr = LocalLockServiceHolder.get().acquireLock(this.object);
        if (lr.isOk()) {
            this.doRun(this.object);
            LocalLockServiceHolder.get().releaseLock(this.object);
        } else {
            LockResponseHelper.showInfo(lr, this.object, log);
        }
    }

    public abstract T getTargetedObject();

    public abstract void doRun(T var1);
}

