/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.exchange;

import ch.elexis.core.model.Identifiable;
import ch.elexis.core.ui.exchange.IDataSender;
import ch.elexis.core.ui.exchange.Messages;
import ch.elexis.core.ui.exchange.XChangeContainer;
import ch.elexis.core.ui.exchange.elements.ContactElement;
import ch.elexis.core.ui.exchange.elements.ContactRefElement;
import ch.elexis.core.ui.exchange.elements.ContactsElement;
import ch.elexis.core.ui.exchange.elements.MedicalElement;
import ch.elexis.core.ui.exchange.elements.XChangeElement;
import ch.elexis.core.ui.exchange.elements.XidElement;
import ch.elexis.data.BezugsKontakt;
import ch.elexis.data.Kontakt;
import ch.elexis.data.Patient;
import ch.elexis.data.PersistentObject;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.jdom2.Document;
import org.jdom2.Element;

public abstract class XChangeExporter
implements IDataSender {
    private final XChangeContainer container = new XChangeContainer();

    @Override
    public boolean canHandle(Class<? extends PersistentObject> clazz) {
        return false;
    }

    @Override
    public boolean canHandle(Identifiable identifiable) {
        return false;
    }

    public Element getRoot() {
        return this.container.getRoot();
    }

    public Document getDocument() {
        return this.container.getDocument();
    }

    public XChangeContainer getContainer() {
        return this.container;
    }

    public ContactElement addContact(Kontakt k) {
        ContactsElement eContacts = this.container.getContactsElement();
        List<? extends XChangeElement> lContacts = eContacts.getChildren("contact", ContactElement.class);
        for (ContactElement contactElement : lContacts) {
            XidElement xid = contactElement.getXid();
            if (xid == null || xid.match((PersistentObject)k) != XidElement.XIDMATCH.SURE) continue;
            return contactElement;
        }
        ContactElement contactElement = new ContactElement().asExporter(this, k);
        eContacts.add(contactElement);
        this.container.addChoice(contactElement.getElement(), k.getLabel(), (Object)k);
        return contactElement;
    }

    public ContactElement addPatient(Patient pat) {
        ContactElement ret = this.addContact((Kontakt)pat);
        List bzl = pat.getBezugsKontakte();
        for (BezugsKontakt bz : bzl) {
            ret.add(new ContactRefElement().asExporter(this, bz));
        }
        MedicalElement eMedical = new MedicalElement().asExporter(this, pat);
        ret.add(eMedical);
        this.getContainer().addChoice(eMedical.getElement(), Messages.XChangeContainer_kg, (Object)eMedical);
        for (IConfigurationElement iConfigurationElement : this.getContainer().getXChangeContributors()) {
        }
        return ret;
    }

    public void addBinary(String id, byte[] contents) {
        this.container.binFiles.put(id, contents);
    }
}

