/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.dialogs;

import ch.elexis.core.l10n.Messages;
import ch.elexis.core.ui.icons.Images;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class PatientPhotoDialog
extends Dialog {
    private final String title;
    private final ImageData sourceData;
    private Image displayImage;
    private Label imageLabel;
    private ScrolledComposite scroller;
    private Composite content;
    private double zoom = 1.0;

    public PatientPhotoDialog(Shell parentShell, String title, ImageData imageData) {
        super(parentShell);
        this.title = title != null && !title.isBlank() ? title : Messages.PatientPhotoDialog_Title_Default;
        this.sourceData = imageData;
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(this.title);
        shell.setMinimumSize(520, 620);
    }

    protected Control createDialogArea(Composite parent) {
        Composite area = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(area, 0);
        container.setLayout((Layout)new GridLayout(1, false));
        container.setLayoutData((Object)new GridData(4, 4, true, true));
        this.scroller = new ScrolledComposite(container, 2816);
        this.scroller.setLayoutData((Object)new GridData(4, 4, true, true));
        this.scroller.setExpandHorizontal(true);
        this.scroller.setExpandVertical(true);
        this.content = new Composite((Composite)this.scroller, 0);
        this.content.setLayout((Layout)new GridLayout(1, false));
        this.imageLabel = new Label(this.content, 0);
        this.imageLabel.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, true));
        this.scroller.setContent((Control)this.content);
        this.applyZoom();
        this.content.addListener(37, ev -> {
            boolean ctrlDown;
            boolean bl = ctrlDown = (ev.stateMask & 0x440000) != 0;
            if (!ctrlDown) {
                return;
            }
            if (ev.count > 0) {
                this.zoomIn();
            } else {
                this.zoomOut();
            }
        });
        this.imageLabel.addListener(8, ev -> this.fitToWidth());
        return area;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        GridLayout layout = new GridLayout(2, true);
        layout.marginWidth = 10;
        layout.marginHeight = 5;
        parent.setLayout((Layout)layout);
        Composite leftGroup = new Composite(parent, 0);
        leftGroup.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        GridLayout leftLayout = new GridLayout(3, false);
        leftLayout.marginWidth = 5;
        leftLayout.horizontalSpacing = 5;
        leftGroup.setLayout((Layout)leftLayout);
        int leftButtonWidth = 55;
        Button outBtn = new Button(leftGroup, 8);
        outBtn.setImage(Images.IMG_ZOOM_OUT.getImage());
        outBtn.setToolTipText(Messages.PatientPhotoDialog_ZoomOut);
        GridData gdOut = new GridData(0x1000000, 0x1000000, false, false);
        gdOut.widthHint = leftButtonWidth;
        outBtn.setLayoutData((Object)gdOut);
        outBtn.addListener(13, e -> this.zoomOut());
        Button resetBtn = new Button(leftGroup, 8);
        resetBtn.setText(Messages.PatientPhotoDialog_ZoomReset);
        GridData gdReset = new GridData(0x1000000, 0x1000000, false, false);
        gdReset.widthHint = leftButtonWidth;
        resetBtn.setLayoutData((Object)gdReset);
        resetBtn.addListener(13, e -> {
            this.zoom = 1.0;
            this.applyZoom();
        });
        Button inBtn = new Button(leftGroup, 8);
        inBtn.setImage(Images.IMG_ZOOM_IN.getImage());
        inBtn.setToolTipText(Messages.PatientPhotoDialog_ZoomIn);
        GridData gdIn = new GridData(0x1000000, 0x1000000, false, false);
        gdIn.widthHint = leftButtonWidth;
        inBtn.setLayoutData((Object)gdIn);
        inBtn.addListener(13, e -> this.zoomIn());
        Composite rightGroup = new Composite(parent, 0);
        rightGroup.setLayoutData((Object)new GridData(0x1000008, 0x1000000, true, false));
        GridLayout rightLayout = new GridLayout(3, false);
        rightLayout.marginWidth = 0;
        rightLayout.horizontalSpacing = 10;
        rightGroup.setLayout((Layout)rightLayout);
        Label spacer = new Label(rightGroup, 0);
        spacer.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        int rightButtonWidth = 110;
        Button fitBtn = new Button(rightGroup, 8);
        fitBtn.setText(Messages.PatientPhotoDialog_FitToWidth);
        GridData gdFit = new GridData(131072, 0x1000000, false, false);
        gdFit.widthHint = rightButtonWidth;
        fitBtn.setLayoutData((Object)gdFit);
        fitBtn.addListener(13, e -> this.fitToWidth());
        Button closeBtn = this.createButton(rightGroup, 12, IDialogConstants.CLOSE_LABEL, true);
        GridData gdClose = new GridData(131072, 0x1000000, false, false);
        gdClose.widthHint = rightButtonWidth;
        closeBtn.setLayoutData((Object)gdClose);
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 12) {
            this.close();
            return;
        }
        super.buttonPressed(buttonId);
    }

    private void zoomIn() {
        this.zoom = Math.min(this.zoom * 1.25, 8.0);
        this.applyZoom();
    }

    private void zoomOut() {
        this.zoom = Math.max(this.zoom / 1.25, 0.1);
        this.applyZoom();
    }

    private void fitToWidth() {
        if (this.scroller == null || this.scroller.isDisposed() || this.sourceData == null) {
            return;
        }
        int imgW = this.sourceData.width;
        int clientW = this.scroller.getClientArea().width;
        if (imgW > 0 && clientW > 0) {
            this.zoom = Math.max(0.1, (double)clientW / (double)imgW);
            this.applyZoom();
        }
    }

    private void applyZoom() {
        if (this.sourceData == null || this.imageLabel == null || this.imageLabel.isDisposed()) {
            return;
        }
        if (this.displayImage != null && !this.displayImage.isDisposed()) {
            this.displayImage.dispose();
            this.displayImage = null;
        }
        int w = Math.max(1, (int)Math.round((double)this.sourceData.width * this.zoom));
        int h = Math.max(1, (int)Math.round((double)this.sourceData.height * this.zoom));
        ImageData scaled = this.sourceData.scaledTo(w, h);
        this.displayImage = new Image((Device)this.getShell().getDisplay(), scaled);
        this.imageLabel.setImage(this.displayImage);
        if (this.content != null && !this.content.isDisposed()) {
            this.content.layout(true, true);
            Point pref = this.content.computeSize(-1, -1);
            pref.x = Math.max(pref.x, w);
            pref.y = Math.max(pref.y, h);
            this.scroller.setMinSize(pref);
        }
    }

    public boolean close() {
        if (this.displayImage != null && !this.displayImage.isDisposed()) {
            this.displayImage.dispose();
        }
        this.displayImage = null;
        return super.close();
    }
}

