/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.actions;

import ch.elexis.core.model.ICoverage;
import ch.elexis.core.model.IEncounter;
import ch.elexis.core.text.model.Samdas;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class KonsFilter {
    public static final int AND = 1;
    public static final int OR = 2;
    public static final int NOT = 4;
    private ICoverage fall;
    private boolean caseSensitive;
    private boolean asRegEx;
    private List<Constraint> lc = new LinkedList<Constraint>();

    public void setFall(ICoverage f) {
        this.fall = f;
    }

    public void addConstraint(int link, String word) {
        this.lc.add(new Constraint(link, word));
    }

    public void clear() {
        this.lc.clear();
    }

    public void setCaseSensitive(boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
    }

    public void setAsRegEx(boolean asRegEx) {
        this.asRegEx = asRegEx;
    }

    public boolean pass(IEncounter k) {
        if (k == null) {
            return false;
        }
        if (k.isDeleted()) {
            return false;
        }
        ICoverage kf = k.getCoverage();
        if (this.fall != null && kf != null && !this.fall.getId().equals(kf.getId())) {
            return false;
        }
        if (this.lc.isEmpty()) {
            return true;
        }
        boolean nVal = true;
        boolean lastVal = false;
        String tx = new Samdas(k.getVersionedEntry().getHead()).getRecordText();
        for (Constraint c : this.lc) {
            boolean matchVal = false;
            if (this.asRegEx) {
                Pattern pat = Pattern.compile(c.word);
                Matcher match = pat.matcher(tx);
                matchVal = match.find();
            } else {
                matchVal = this.caseSensitive ? tx.indexOf(c.word) != -1 : tx.toLowerCase().indexOf(c.word.toLowerCase()) != -1;
            }
            boolean neg = (c.mode & 4) != 0;
            nVal = matchVal ^ neg;
            if ((c.mode & 2) != 0) {
                if (!lastVal && !nVal) {
                    return false;
                }
                lastVal = true;
                continue;
            }
            if ((c.mode & 1) != 0) {
                if (!lastVal || !nVal) {
                    return false;
                }
                lastVal = true;
                continue;
            }
            lastVal = nVal;
        }
        return lastVal;
    }

    private static class Constraint {
        int mode;
        String word;

        Constraint(int m, String w) {
            this.mode = m;
            this.word = w;
        }
    }
}

