/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.actions;

import ch.elexis.core.ui.actions.BackgroundJob;
import ch.rgw.tools.ExHandler;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.core.runtime.jobs.IJobManager;
import org.eclipse.core.runtime.jobs.ILock;
import org.eclipse.core.runtime.jobs.Job;

@Deprecated
public class JobPool
implements BackgroundJob.BackgroundJobListener {
    private Hashtable<String, BackgroundJob> pool = new Hashtable();
    private Vector<String> running = new Vector();
    private Vector<String> waiting = new Vector();
    private Vector<String> queued = new Vector();
    private ILock changeLock;
    private static JobPool thePool;

    private JobPool() {
        IJobManager jobman = Job.getJobManager();
        this.changeLock = jobman.newLock();
    }

    public void dispose() {
        for (BackgroundJob job : this.pool.values()) {
            try {
                if (job.cancel()) continue;
                job.getThread().interrupt();
            }
            catch (Throwable t) {
                ExHandler.handle((Throwable)t);
            }
        }
    }

    public static JobPool getJobPool() {
        if (thePool == null) {
            thePool = new JobPool();
        }
        return thePool;
    }

    public boolean addJob(BackgroundJob job) {
        try {
            this.changeLock.acquire();
            if (this.pool.get(job.getJobname()) != null) {
                return false;
            }
            job.addListener(this);
            this.pool.put(job.getJobname(), job);
            this.waiting.add(job.getJobname());
            return true;
        }
        catch (Exception ex) {
            ExHandler.handle((Throwable)ex);
            return false;
        }
        finally {
            this.changeLock.release();
        }
    }

    public BackgroundJob getJob(String name) {
        BackgroundJob ret = this.pool.get(name);
        return ret;
    }

    public boolean activate(String name, int priority) {
        try {
            this.changeLock.acquire();
            if (this.waiting.remove(name)) {
                BackgroundJob job = this.pool.get(name);
                if (job == null) {
                    return false;
                }
                this.running.add(name);
                job.setPriority(priority);
                job.schedule();
                return true;
            }
            return false;
        }
        catch (Exception ex) {
            ExHandler.handle((Throwable)ex);
            return false;
        }
        finally {
            this.changeLock.release();
        }
    }

    public void queue(String name) {
        block6: {
            try {
                try {
                    this.changeLock.acquire();
                    if (this.running.isEmpty()) {
                        this.activate(name, 40);
                        break block6;
                    }
                    this.queued.add(name);
                }
                catch (Exception ex) {
                    ExHandler.handle((Throwable)ex);
                    this.changeLock.release();
                }
            }
            finally {
                this.changeLock.release();
            }
        }
    }

    @Override
    public void jobFinished(BackgroundJob j) {
        try {
            try {
                this.changeLock.acquire();
                this.running.remove(j.getJobname());
                this.waiting.add(j.getJobname());
                if (!this.queued.isEmpty()) {
                    String nextJob = this.queued.remove(0);
                    this.activate(nextJob, 40);
                }
            }
            catch (Exception e) {
                ExHandler.handle((Throwable)e);
                this.changeLock.release();
            }
        }
        finally {
            this.changeLock.release();
        }
    }
}

