/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui;

import ch.elexis.core.constants.Elexis;
import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.data.interfaces.ShutdownJob;
import ch.elexis.core.data.interfaces.scripting.Interpreter;
import ch.elexis.core.data.util.NoPoUtil;
import ch.elexis.core.events.MessageEvent;
import ch.elexis.core.l10n.Messages;
import ch.elexis.core.model.IMandator;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.model.IUser;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.services.holder.ConfigServiceHolder;
import ch.elexis.core.services.holder.ContextServiceHolder;
import ch.elexis.core.time.TimeUtil;
import ch.elexis.core.ui.ElexisConfigurationConstants;
import ch.elexis.core.ui.UiDesk;
import ch.elexis.core.ui.actions.GlobalActions;
import ch.elexis.core.ui.commands.sourceprovider.PatientSelectionStatus;
import ch.elexis.core.ui.dialogs.ReminderListSelectionDialog;
import ch.elexis.core.ui.e4.util.CoreUiUtil;
import ch.elexis.core.ui.preferences.PreferenceInitializer;
import ch.elexis.data.Anwender;
import ch.elexis.data.Kontakt;
import ch.elexis.data.Mandant;
import ch.elexis.data.Patient;
import ch.elexis.data.Reminder;
import ch.elexis.data.VerrechenbarFavorites;
import ch.rgw.tools.TimeTool;
import jakarta.inject.Inject;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.services.ISourceProviderService;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Hub
extends AbstractUIPlugin {
    public static final String APPLICATION_NAME = "Elexis";
    public static final String PLUGIN_ID = "ch.elexis.core.ui";
    public static final String COMMAND_PREFIX = "ch.elexis.core.ui.commands.";
    public static final String SWTBOTTEST_KEY = "ch.elexis.swtbottest.key";
    static final String[] mine = new String[]{"ch.elexis", "ch.rgw"};
    private static Logger log = LoggerFactory.getLogger((String)Hub.class.getName());
    private static List<ShutdownJob> shutdownJobs = new LinkedList<ShutdownJob>();
    public static final PreferenceInitializer pin = new PreferenceInitializer();
    public static boolean ecc = ElexisConfigurationConstants.init();
    public static Hub plugin;
    public static GlobalActions mainActions;
    @Inject
    private ISourceProviderService sps;
    @Inject
    private ICommandService commandService;
    private Anwender lastLoggedInContact;

    @Inject
    public void activePatient(@Optional IPatient patient) {
        Display.getDefault().syncExec(() -> Hub.setWindowText(patient));
        PatientSelectionStatus provider = (PatientSelectionStatus)this.sps.getSourceProvider("ch.elexis.commands.sourceprovider.patientSelectionActive");
        if (provider != null) {
            provider.setState(patient != null);
        }
        this.showPatientChangeReminders((Patient)NoPoUtil.loadAsPersistentObject((Identifiable)patient, Patient.class));
    }

    private void showPatientChangeReminders(Patient patient) {
        if (patient != null && ConfigServiceHolder.getUser((String)"reminder/showPatientChangeReminder", (boolean)false)) {
            CompletableFuture.runAsync(() -> {
                List list = Reminder.findOpenRemindersResponsibleFor((Anwender)CoreHub.getLoggedInContact(), (boolean)false, (Patient)patient, (boolean)true);
                if (!list.isEmpty()) {
                    StringBuilder sb = new StringBuilder();
                    for (Reminder r : list) {
                        sb.append(r.getSubject() + "\n");
                        sb.append(r.getMessage() + "\n\n");
                    }
                    MessageEvent.fireInformation((String)Messages.PatientEventListener_0, (String)sb.toString());
                }
            });
        }
    }

    @Inject
    public void activeMandator(@Optional IMandator mandator) {
        Hub.setWindowText(null);
        if (mandator != null) {
            CoreHub.actMandant = Mandant.load((String)mandator.getId());
        }
    }

    @Inject
    void activeUser(@Optional IUser user) {
        this.updateUser(user);
    }

    private void updateUser(IUser user) {
        if (CoreHub.getLoggedInContact() != null) {
            Anwender loggedInContact = CoreHub.getLoggedInContact();
            if (this.lastLoggedInContact == null || !this.lastLoggedInContact.equals((Object)loggedInContact)) {
                CompletableFuture.runAsync(() -> {
                    final List reminderList = Reminder.findToShowOnStartup((Anwender)loggedInContact);
                    if (!reminderList.isEmpty()) {
                        UiDesk.runIfWorkbenchRunning(() -> Display.getDefault().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                new ReminderListSelectionDialog(reminderList, Messages.ReminderView_importantRemindersOnLogin).open();
                            }
                        }));
                    }
                });
                this.lastLoggedInContact = loggedInContact;
            }
        }
        VerrechenbarFavorites.reset();
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        log.debug("Starting " + ((Object)((Object)this)).getClass().getName());
        plugin = this;
        System.setProperty("chromium.cache_path", Files.createTempDirectory("chromium", new FileAttribute[0]).toFile().getAbsolutePath());
        CoreUiUtil.injectServicesWithContext((Object)((Object)this));
        Interpreter.classLoaders.add(Hub.class.getClassLoader());
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        log.debug("Stopping " + ((Object)((Object)this)).getClass().getName());
        super.stop(context);
    }

    public static void postShutdown() {
        if (shutdownJobs != null && !shutdownJobs.isEmpty()) {
            Shell shell = new Shell(Display.getDefault());
            MessageDialog dlg = new MessageDialog(shell, Messages.Hub_title_configuration, Dialog.getDefaultImage(), Messages.Hub_message_configuration, 2, new String[0], 0);
            dlg.setBlockOnOpen(false);
            dlg.open();
            for (ShutdownJob job : shutdownJobs) {
                try {
                    job.doit();
                }
                catch (Exception e) {
                    log.error("Error starting job: " + e.getMessage());
                }
            }
            dlg.close();
        }
    }

    public static void setMandant(Mandant m) {
        CoreHub.setMandant((Mandant)m);
    }

    public static void setWindowText(IPatient patient) {
        Shell shell;
        StringBuilder sb = new StringBuilder();
        sb.append("Elexis ").append(Elexis.VERSION).append(" - ");
        if (CoreHub.getLoggedInContact() == null) {
            sb.append(Messages.Hub_nouserloggedin);
        } else {
            sb.append(" ").append(CoreHub.getLoggedInContact().getLabel());
        }
        if (ContextServiceHolder.getActiveMandatorOrNull() == null) {
            sb.append(Messages.Hub_nomandantor);
        } else {
            sb.append(" / ").append(ContextServiceHolder.getActiveMandatorOrNull().getLabel());
        }
        if (patient == null) {
            patient = ContextServiceHolder.get().getActivePatient().orElse(null);
        }
        if (patient == null) {
            sb.append(Messages.Hub_nopatientselected);
        } else {
            String nr = patient.getPatientNr();
            String alter = Integer.toString(patient.getAgeInYears());
            sb.append("  / ").append(patient.getLabel()).append(" (").append(alter).append(") - ").append("[").append(nr).append("]");
            if (!Reminder.findForPatient((Patient)((Patient)NoPoUtil.loadAsPersistentObject((Identifiable)patient, Patient.class)), (Kontakt)CoreHub.getLoggedInContact()).isEmpty()) {
                sb.append(Messages.Hub_message_reminders);
            }
            String act = new TimeTool().toString(9);
            LocalDateTime ttPatg = patient.getDateOfBirth();
            if (ttPatg != null) {
                String patg = TimeUtil.formatSafe((LocalDate)ttPatg.toLocalDate());
                if (LocalDate.now().equals(ttPatg.toLocalDate().withYear(LocalDate.now().getYear()))) {
                    sb.append(Messages.Hub_message_birthday);
                }
            }
        }
        if (Hub.mainActions.mainWindow != null && (shell = Hub.mainActions.mainWindow.getShell()) != null && !shell.isDisposed()) {
            Display.getDefault().asyncExec(() -> Hub.mainActions.mainWindow.getShell().setText(sb.toString()));
        }
    }

    public static Shell getActiveShell() {
        IWorkbenchWindow win;
        IWorkbench wb;
        if (plugin != null && (wb = plugin.getWorkbench()) != null && (win = wb.getActiveWorkbenchWindow()) != null) {
            return win.getShell();
        }
        Display dis = UiDesk.getDisplay();
        if (dis == null) {
            dis = PlatformUI.createDisplay();
        }
        return new Shell(dis);
    }

    public static List<Mandant> getMandantenList() {
        return CoreHub.getMandantenList();
    }

    public static List<Anwender> getUserList() {
        return CoreHub.getUserList();
    }

    @Deprecated
    public static void addShutdownJob(ShutdownJob job) {
        if (!shutdownJobs.contains(job)) {
            shutdownJobs.add(job);
        }
    }
}

