/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.util;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.command.ILayerCommand;
import org.eclipse.nebula.widgets.nattable.config.AbstractUiBindingConfiguration;
import org.eclipse.nebula.widgets.nattable.config.IConfiguration;
import org.eclipse.nebula.widgets.nattable.data.IRowDataProvider;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.ILayerListener;
import org.eclipse.nebula.widgets.nattable.layer.event.ILayerEvent;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;
import org.eclipse.nebula.widgets.nattable.selection.command.ClearAllSelectionsCommand;
import org.eclipse.nebula.widgets.nattable.selection.command.SelectRowsCommand;
import org.eclipse.nebula.widgets.nattable.selection.event.CellSelectionEvent;
import org.eclipse.nebula.widgets.nattable.ui.action.IMouseAction;
import org.eclipse.nebula.widgets.nattable.ui.binding.UiBindingRegistry;
import org.eclipse.nebula.widgets.nattable.ui.matcher.IMouseEventMatcher;
import org.eclipse.nebula.widgets.nattable.ui.matcher.MouseEventMatcher;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.graphics.Point;

public class NatTableWrapper
implements ISelectionProvider {
    private NatTable natTable;
    private IRowDataProvider<Object> dataProvider;
    private SelectionLayer selectionLayer;
    private List<Object> currentSelection = new ArrayList<Object>();
    private ListenerList doubleClickListeners = new ListenerList();
    private ListenerList selectionListener = new ListenerList();

    protected void setSelectionLayer(SelectionLayer selectionLayer) {
        this.selectionLayer = selectionLayer;
    }

    public SelectionLayer getSelectionLayer() {
        return this.selectionLayer;
    }

    protected void setDataProvider(IRowDataProvider<Object> dataProvider) {
        this.dataProvider = dataProvider;
    }

    public IRowDataProvider<?> getDataProvider() {
        return this.dataProvider;
    }

    public boolean isDisposed() {
        return this.natTable == null || this.natTable.isDisposed();
    }

    protected void setNatTable(NatTable natTable) {
        this.natTable = natTable;
    }

    public void configure() {
        this.natTable.addLayerListener(new ILayerListener(){

            public void handleLayerEvent(ILayerEvent event) {
                if (event instanceof CellSelectionEvent) {
                    int[] selectedIdxs;
                    NatTableWrapper.this.currentSelection.clear();
                    CellSelectionEvent cellEvent = (CellSelectionEvent)event;
                    int[] nArray = selectedIdxs = cellEvent.getSelectionLayer().getFullySelectedRowPositions();
                    int n = selectedIdxs.length;
                    int n2 = 0;
                    while (n2 < n) {
                        int selectionIdx = nArray[n2];
                        NatTableWrapper.this.currentSelection.add(NatTableWrapper.this.dataProvider.getRowObject(selectionIdx));
                        ++n2;
                    }
                }
            }
        });
        this.natTable.addConfiguration((IConfiguration)new AbstractUiBindingConfiguration(){

            public void configureUiBindings(UiBindingRegistry uiBindingRegistry) {
                uiBindingRegistry.registerDoubleClickBinding((IMouseEventMatcher)new MouseEventMatcher(0, "BODY", 1), (IMouseAction)new DblClickMouseAction());
            }

            class DblClickMouseAction
            implements IMouseAction {
                DblClickMouseAction() {
                }

                public void run(NatTable natTable, MouseEvent event) {
                    if ((this).NatTableWrapper.this.currentSelection != null && (this).NatTableWrapper.this.currentSelection.size() == 1) {
                        Object[] listeners;
                        Object[] objectArray = listeners = (this).NatTableWrapper.this.doubleClickListeners.getListeners();
                        int n = listeners.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Object object = objectArray[n2];
                            ((IDoubleClickListener)object).doubleClick(NatTableWrapper.this, NatTableWrapper.this.getSelection());
                            ++n2;
                        }
                    }
                }
            }
        });
        this.natTable.configure();
    }

    public NatTable getNatTable() {
        return this.natTable;
    }

    public void addDoubleClickListener(IDoubleClickListener listener) {
        this.doubleClickListeners.add((Object)listener);
    }

    public void removeDoubleClickListener(IDoubleClickListener listener) {
        this.doubleClickListeners.remove((Object)listener);
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionListener.add((Object)listener);
    }

    public ISelection getSelection() {
        if (!this.currentSelection.isEmpty()) {
            return new StructuredSelection(this.currentSelection);
        }
        return StructuredSelection.EMPTY;
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionListener.remove((Object)listener);
    }

    public void setSelection(ISelection selection) {
        if (selection instanceof StructuredSelection) {
            if (!selection.isEmpty()) {
                List list = ((StructuredSelection)selection).toList();
                int[] rowIdx = new int[list.size()];
                int i = 0;
                while (i < list.size()) {
                    rowIdx[i] = this.dataProvider.indexOfRowObject(list.get(i));
                    ++i;
                }
                this.natTable.doCommand((ILayerCommand)new SelectRowsCommand((ILayer)this.selectionLayer, 0, rowIdx, false, false, rowIdx[0]));
            } else {
                this.natTable.doCommand((ILayerCommand)new ClearAllSelectionsCommand());
            }
        }
    }

    public Point computeSize(int wHint, int hHint) {
        Point ret = this.natTable.computeSize(wHint, hHint);
        int calcHeight = this.calculateHeight();
        if (calcHeight > ret.y) {
            ret.y = calcHeight;
        }
        return ret;
    }

    private int calculateHeight() {
        return this.natTable.getPreferredHeight() + 20;
    }

    public static interface IDoubleClickListener {
        public void doubleClick(NatTableWrapper var1, ISelection var2);
    }
}

