/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.preferences;

import ch.elexis.core.data.util.Extensions;
import ch.elexis.core.services.holder.ConfigServiceHolder;
import ch.elexis.core.status.ElexisStatus;
import ch.elexis.core.ui.icons.Images;
import ch.elexis.core.ui.preferences.Messages;
import ch.elexis.core.ui.views.IDetailDisplay;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerDropAdapter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class ServiceDiagnosePrefs
extends PreferencePage
implements IWorkbenchPreferencePage {
    private static final String FAVORITES = "Favoriten";
    private ComboViewer cmbViewer;
    private TableViewer viewer;
    private TableViewer viewerAvailable;
    private List<String> input;
    private List<String> aInput;

    public ServiceDiagnosePrefs() {
        super("Leistungen u. Diagnosen");
    }

    protected Control createContents(Composite parent) {
        Composite ret = new Composite(parent, 0);
        ret.setLayout((Layout)new GridLayout(3, true));
        Label lblView = new Label(ret, 0);
        lblView.setText(Messages.ServiceDiagnosis_View);
        lblView.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 3, 1));
        this.cmbViewer = new ComboViewer(ret, 8);
        Combo combo = this.cmbViewer.getCombo();
        combo.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 3, 1));
        this.cmbViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.cmbViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        this.cmbViewer.setInput((Object)ViewType.values());
        this.cmbViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                ViewType view = (ViewType)((Object)selection.getFirstElement());
                ServiceDiagnosePrefs.this.loadInput(view);
            }
        });
        int operations = 10;
        Transfer[] transferTypes = new Transfer[]{TextTransfer.getInstance()};
        new Label(ret, 0);
        new Label(ret, 0);
        new Label(ret, 0);
        Label lblDisplayed = new Label(ret, 0);
        lblDisplayed.setText(Messages.ServiceDiagnosis_Displayed);
        new Label(ret, 0);
        Label lblAvailable = new Label(ret, 0);
        lblAvailable.setText(Messages.ServiceDiagnosis_Available);
        Label label = new Label(ret, 258);
        label.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 3, 1));
        this.viewer = new TableViewer(ret, 772);
        Table table = this.viewer.getTable();
        table.setHeaderVisible(false);
        table.setLinesVisible(false);
        GridData gd_v = new GridData(4, 128, true, false, 1, 1);
        gd_v.widthHint = 150;
        gd_v.heightHint = 200;
        gd_v.minimumWidth = 150;
        gd_v.minimumHeight = 200;
        table.setLayoutData((Object)gd_v);
        this.createColumn(ret, this.viewer);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setInput(this.input);
        this.viewer.addDragSupport(operations, transferTypes, (DragSourceListener)new DragListener((Viewer)this.viewer, true));
        this.viewer.addDropSupport(operations, transferTypes, (DropTargetListener)new DropListener((Viewer)this.viewer, true));
        Composite btnComposite = new Composite(ret, 0);
        btnComposite.setLayout((Layout)new GridLayout(1, false));
        btnComposite.setLayoutData((Object)new GridData(16384, 4, true, false));
        Button btnUp = new Button(btnComposite, 8);
        btnUp.setImage(Images.IMG_ARROWUP.getImage());
        btnUp.setLayoutData((Object)new GridData(16384, 128, false, false));
        btnUp.setToolTipText(Messages.ServiceDiagnosis_UpTooltip);
        btnUp.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = (IStructuredSelection)ServiceDiagnosePrefs.this.viewer.getSelection();
                String value = (String)selection.getFirstElement();
                int idx = ServiceDiagnosePrefs.this.input.indexOf(value);
                if (idx > 0) {
                    ServiceDiagnosePrefs.this.input.remove(value);
                    ServiceDiagnosePrefs.this.input.add(idx - 1, value);
                    ServiceDiagnosePrefs.this.viewer.refresh();
                }
            }
        });
        Button btnDown = new Button(btnComposite, 8);
        btnDown.setImage(Images.IMG_ARROWDOWN.getImage());
        btnDown.setLayoutData((Object)new GridData(16384, 128, false, false));
        btnDown.setToolTipText(Messages.ServiceDiagnosis_DownTooltip);
        btnDown.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = (IStructuredSelection)ServiceDiagnosePrefs.this.viewer.getSelection();
                String value = (String)selection.getFirstElement();
                int idx = ServiceDiagnosePrefs.this.input.indexOf(value);
                if (idx != -1 && idx < ServiceDiagnosePrefs.this.input.size() - 1) {
                    ServiceDiagnosePrefs.this.input.remove(value);
                    ServiceDiagnosePrefs.this.input.add(idx + 1, value);
                    ServiceDiagnosePrefs.this.viewer.refresh();
                }
            }
        });
        this.viewerAvailable = new TableViewer(ret, 772);
        table = this.viewerAvailable.getTable();
        table.setHeaderVisible(false);
        table.setLinesVisible(false);
        GridData gd_va = new GridData(4, 128, true, false, 1, 1);
        gd_va.widthHint = 150;
        gd_va.heightHint = 200;
        gd_va.minimumWidth = 150;
        gd_va.minimumHeight = 200;
        table.setLayoutData((Object)gd_va);
        this.createColumn(ret, this.viewerAvailable);
        this.viewerAvailable.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewerAvailable.setInput(this.aInput);
        this.viewerAvailable.addDragSupport(operations, transferTypes, (DragSourceListener)new DragListener((Viewer)this.viewerAvailable, false));
        this.viewerAvailable.addDropSupport(operations, transferTypes, (DropTargetListener)new DropListener((Viewer)this.viewerAvailable, false));
        this.cmbViewer.setSelection((ISelection)new StructuredSelection((Object)ViewType.Leistungen));
        return ret;
    }

    private void createColumn(Composite parent, TableViewer viewer) {
        TableViewerColumn tvCol = new TableViewerColumn(viewer, 0);
        tvCol.setLabelProvider((CellLabelProvider)new ColumnLabelProvider());
        TableColumn column = tvCol.getColumn();
        column.setText("");
        column.setWidth(150);
        column.setResizable(false);
        column.setMoveable(false);
    }

    private void loadInput(ViewType view) {
        String[] settings = new String[]{};
        this.input = new ArrayList<String>();
        this.aInput = new ArrayList<String>();
        switch (view) {
            case Leistungen: {
                this.aInput.addAll(this.findPagesFor("ch.elexis.core.ui.Verrechnungscode", null));
                this.aInput.add(FAVORITES);
                settings = ConfigServiceHolder.getUser((String)"servicediagnose/srv", (String)this.getListAsString(this.aInput)).split(",");
                break;
            }
            case Diagnose: {
                this.aInput.addAll(this.findPagesFor("ch.elexis.core.ui.Diagnosecode", null));
                settings = ConfigServiceHolder.getUser((String)"servicediagnose/diagnose", (String)this.getListAsString(this.aInput)).split(",");
                break;
            }
            case Codes: {
                this.aInput.addAll(this.findPagesFor("ch.elexis.core.ui.Verrechnungscode", "Artikel"));
                this.aInput.addAll(this.findPagesFor("ch.elexis.core.ui.Diagnosecode", "Artikel"));
                this.aInput.addAll(this.findPagesFor("ch.elexis.core.ui.Genericcode", "Artikel"));
                this.aInput.add(FAVORITES);
                settings = ConfigServiceHolder.getUser((String)"servicediagnose/codes", (String)this.getListAsString(this.aInput)).split(",");
                break;
            }
        }
        String[] stringArray = settings;
        int n = settings.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            this.input.add(s);
            this.aInput.remove(s);
            ++n2;
        }
        this.viewer.setInput(this.input);
        this.viewerAvailable.setInput(this.aInput);
    }

    private String getListAsString(List<String> list) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < list.size()) {
            sb.append(list.get(i));
            if (i != list.size() - 1) {
                sb.append(",");
            }
            ++i;
        }
        return sb.toString();
    }

    private List<String> findPagesFor(String point, String ignore) {
        ArrayList<String> pageNames = new ArrayList<String>();
        List list = Extensions.getExtensions((String)point);
        for (IConfigurationElement ce : list) {
            try {
                if (ignore != null && ignore.equals(ce.getName())) continue;
                IDetailDisplay d = (IDetailDisplay)ce.createExecutableExtension("CodeDetailDisplay");
                pageNames.add(d.getTitle().trim());
            }
            catch (Exception ex) {
                new ElexisStatus(2, "ch.elexis.core.ui", 0, "Fehler beim Laden von " + ce.getName(), ex, 3);
            }
        }
        return pageNames;
    }

    public void init(IWorkbench workbench) {
    }

    protected void performApply() {
        IStructuredSelection selection = (IStructuredSelection)this.cmbViewer.getSelection();
        ViewType type = (ViewType)((Object)selection.getFirstElement());
        if (type != null) {
            String listString = this.getListAsString(this.input);
            switch (type) {
                case Leistungen: {
                    ConfigServiceHolder.setUser((String)"servicediagnose/srv", (String)listString);
                    break;
                }
                case Diagnose: {
                    ConfigServiceHolder.setUser((String)"servicediagnose/diagnose", (String)listString);
                    break;
                }
                case Codes: {
                    ConfigServiceHolder.setUser((String)"servicediagnose/codes", (String)listString);
                    break;
                }
            }
        }
        super.performApply();
    }

    class DragListener
    implements DragSourceListener {
        private final TableViewer viewer;
        private boolean isUserSet;
        private String movedValue;

        public DragListener(Viewer viewer, boolean isUserSet) {
            this.viewer = (TableViewer)viewer;
            this.isUserSet = isUserSet;
        }

        public void dragSetData(DragSourceEvent event) {
            IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
            String value = (String)selection.getFirstElement();
            if (TextTransfer.getInstance().isSupportedType(event.dataType)) {
                event.data = value;
                this.movedValue = value;
            }
        }

        public void dragStart(DragSourceEvent event) {
        }

        public void dragFinished(DragSourceEvent event) {
            if (this.isUserSet) {
                ServiceDiagnosePrefs.this.input.remove(this.movedValue);
            } else {
                ServiceDiagnosePrefs.this.aInput.remove(this.movedValue);
            }
            this.viewer.refresh();
        }
    }

    class DropListener
    extends ViewerDropAdapter {
        private final TableViewer viewer;
        private boolean isUserSet;

        protected DropListener(Viewer viewer, boolean isUserSet) {
            super(viewer);
            this.viewer = (TableViewer)viewer;
            this.isUserSet = isUserSet;
        }

        public boolean performDrop(Object data) {
            if (this.isUserSet) {
                ServiceDiagnosePrefs.this.input.add(data.toString());
            } else {
                ServiceDiagnosePrefs.this.aInput.add(data.toString());
            }
            this.viewer.refresh();
            return true;
        }

        public boolean validateDrop(Object target, int operation, TransferData transferType) {
            return true;
        }
    }

    static enum ViewType {
        Leistungen,
        Diagnose,
        Codes;

    }
}

