/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.usage.settings;

import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.services.holder.ConfigServiceHolder;
import ch.elexis.core.ui.icons.Images;
import ch.elexis.core.ui.usage.model.IStatistic;
import ch.elexis.core.ui.usage.model.ModelPackage;
import ch.elexis.core.ui.usage.util.StatisticsManager;
import ch.rgw.tools.TimeTool;
import java.io.IOException;
import java.util.Comparator;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.databinding.EMFProperties;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.databinding.viewers.ObservableListContentProvider;
import org.eclipse.jface.databinding.viewers.ObservableMapCellLabelProvider;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.slf4j.LoggerFactory;

public class UsageSettings
extends PreferencePage
implements IWorkbenchPreferencePage {
    public static final String CONFIG_USAGE_STATISTICS = "statistics/usage/sentUsageStatistics";
    private Button checkSentStatistics;

    public void init(IWorkbench workbench) {
    }

    protected Control createContents(Composite parent) {
        Composite main = new Composite(parent, 0);
        main.setLayout((Layout)new GridLayout(1, false));
        main.setLayoutData((Object)new GridData(4, 4, true, true));
        TableViewer viewer = new TableViewer(main, 67588);
        viewer.getTable().setLayoutData((Object)new GridData(1808));
        viewer.getTable().setHeaderVisible(true);
        ObservableListContentProvider cp = new ObservableListContentProvider();
        TableViewerColumn tvc = new TableViewerColumn(viewer, 16384);
        tvc.getColumn().setText("Zeitpunkt");
        tvc.getColumn().setWidth(80);
        tvc.setLabelProvider((CellLabelProvider)new ObservableMapCellLabelProvider(EMFProperties.value((EStructuralFeature)ModelPackage.Literals.ISTATISTIC__TIME).observeDetail(cp.getKnownElements())){

            public void update(ViewerCell cell) {
                IStatistic iStatistic = (IStatistic)cell.getElement();
                if (iStatistic.getTime() != null) {
                    TimeTool t = new TimeTool(iStatistic.getTime());
                    cell.setText(t.toString(2));
                } else {
                    super.update(cell);
                }
            }
        });
        tvc = new TableViewerColumn(viewer, 16384);
        tvc.getColumn().setText("Typ");
        tvc.getColumn().setWidth(120);
        tvc.setLabelProvider((CellLabelProvider)new ObservableMapCellLabelProvider(EMFProperties.value((EStructuralFeature)ModelPackage.Literals.ISTATISTIC__ACTION_TYPE).observeDetail(cp.getKnownElements())));
        tvc = new TableViewerColumn(viewer, 16384);
        tvc.getColumn().setText("Aktion");
        tvc.getColumn().setWidth(300);
        tvc.setLabelProvider((CellLabelProvider)new ObservableMapCellLabelProvider(EMFProperties.value((EStructuralFeature)ModelPackage.Literals.ISTATISTIC__ACTION).observeDetail(cp.getKnownElements())));
        tvc = new TableViewerColumn(viewer, 16384);
        tvc.getColumn().setText("Wert");
        tvc.getColumn().setWidth(50);
        tvc.setLabelProvider((CellLabelProvider)new ObservableMapCellLabelProvider(EMFProperties.value((EStructuralFeature)ModelPackage.Literals.ISTATISTIC__VALUE).observeDetail(cp.getKnownElements())));
        viewer.setContentProvider((IContentProvider)cp);
        ECollections.sort(StatisticsManager.INSTANCE.getStatistics().getStatistics(), (Comparator)new Comparator<IStatistic>(){

            @Override
            public int compare(IStatistic o1, IStatistic o2) {
                int i = o2.getTime().compareTo(o1.getTime());
                if (i == 0) {
                    return o1.getActionType().compareTo(o2.getActionType());
                }
                return i;
            }
        });
        viewer.setInput((Object)EMFProperties.list((EStructuralFeature)ModelPackage.Literals.STATISTICS__STATISTICS).observe((Object)StatisticsManager.INSTANCE.getStatistics()));
        this.addContextMenuSupport(viewer, this.createMenu(viewer));
        this.checkSentStatistics = new Button(main, 32);
        this.checkSentStatistics.setText("Nutzungsstatistik aktivieren und beim Beenden \u00fcbermitteln (Neustart erforderlich)");
        this.checkSentStatistics.setSelection(ConfigServiceHolder.getGlobal((String)CONFIG_USAGE_STATISTICS, (boolean)false));
        return main;
    }

    public void addContextMenuSupport(TableViewer tableViewer, MenuManager menuManager) {
        Table table = tableViewer.getTable();
        Menu menu = menuManager.createContextMenu((Control)table);
        table.setMenu(menu);
    }

    private MenuManager createMenu(final TableViewer tableViewer) {
        MenuManager menuManager = new MenuManager();
        Action clearAction = new Action("Leeren"){
            {
                super($anonymous0);
                this.setImageDescriptor(Images.IMG_DELETE.getImageDescriptor());
                this.setToolTipText("Statistik Leeren");
            }

            public void run() {
                StatisticsManager.INSTANCE.getStatistics().getStatistics().clear();
                tableViewer.refresh();
            }
        };
        Action exportAction = new Action("Exportieren"){
            {
                this.setImageDescriptor(Images.IMG_EXPORT.getImageDescriptor());
                this.setToolTipText("Statistik Exportieren");
            }

            public void run() {
                FileDialog dialog = new FileDialog(UsageSettings.this.getShell(), 8192);
                dialog.setFilterNames(new String[]{"xml"});
                dialog.setFilterExtensions(new String[]{"*.xml"});
                dialog.setOverwrite(true);
                dialog.setFilterPath(CoreHub.getWritableUserDir().getAbsolutePath());
                dialog.setFileName("statistics_export.xml");
                String path = dialog.open();
                if (path != null) {
                    try {
                        StatisticsManager.INSTANCE.exportStatisticsToFile(path);
                    }
                    catch (IOException e) {
                        LoggerFactory.getLogger(UsageSettings.class).error("statistics export error", (Throwable)e);
                        MessageDialog.openError((Shell)UsageSettings.this.getShell(), (String)"Fehler", (String)("Statistik Export nicht m\u00f6glich. [" + e.getMessage() + "]"));
                    }
                }
            }
        };
        menuManager.add((IAction)clearAction);
        menuManager.add((IAction)exportAction);
        return menuManager;
    }

    protected void performApply() {
        ConfigServiceHolder.setGlobal((String)CONFIG_USAGE_STATISTICS, (boolean)this.checkSentStatistics.getSelection());
    }

    public boolean performOk() {
        this.performApply();
        return super.performOk();
    }
}

