/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.tasks.parts;

import ch.elexis.core.services.IQuery;
import ch.elexis.core.tasks.model.ITask;
import ch.elexis.core.tasks.model.ITaskDescriptor;
import ch.elexis.core.tasks.model.ITaskService;
import ch.elexis.core.tasks.model.ModelPackage;
import ch.elexis.core.ui.tasks.internal.TaskModelServiceHolder;
import ch.elexis.core.ui.tasks.parts.TaskLogPart;
import java.util.List;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.menu.MDirectToolItem;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.viewers.AcceptAllFilter;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IFilter;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ListDialog;

public class TaskLogFilterDialog {
    private ITaskDescriptor td;
    private MDirectToolItem item;
    private IFilter showSelectedTask;

    @Execute
    public void execute(Shell shell, ITaskService taskService, MPart part, MDirectToolItem item) {
        TaskLogPart taskResultPart = (TaskLogPart)part.getObject();
        this.item = item;
        if (item.isSelected()) {
            this.openTaskSelectionDialog();
            this.showSelectedTask = object -> ((ITask)object).getTaskDescriptor().getReferenceId().equals(this.td.getReferenceId());
            taskResultPart.getContentProvider().setFilter(this.showSelectedTask);
        } else {
            taskResultPart.getContentProvider().setFilter(AcceptAllFilter.getInstance());
        }
    }

    private ITaskDescriptor openTaskSelectionDialog() {
        IQuery taskDescriptorQuery = TaskModelServiceHolder.get().getQuery(ITaskDescriptor.class);
        taskDescriptorQuery.and((EStructuralFeature)ModelPackage.Literals.ITASK__SYSTEM, IQuery.COMPARATOR.EQUALS, (Object)false);
        List list = taskDescriptorQuery.execute();
        LabelProvider lp = new LabelProvider(){

            public String getText(Object element) {
                ITaskDescriptor iTaskDescriptor = (ITaskDescriptor)element;
                return iTaskDescriptor.getReferenceId();
            }
        };
        ListDialog listDialog = new ListDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
        listDialog.setContentProvider((IStructuredContentProvider)ArrayContentProvider.getInstance());
        listDialog.setInput((Object)list);
        listDialog.setLabelProvider((ILabelProvider)lp);
        listDialog.setMessage("Nach Task filtern");
        int open = listDialog.open();
        if (open == 0) {
            Object[] selection = listDialog.getResult();
            if (selection != null) {
                this.td = (ITaskDescriptor)selection[0];
            }
        } else {
            this.item.setSelected(false);
        }
        return this.td;
    }
}

