/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.tasks.internal.detailcontributors;

import ch.elexis.core.services.IVirtualFilesystemService;
import ch.elexis.core.tasks.model.ITask;
import ch.rgw.tools.Result;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.e4.core.commands.ECommandService;
import org.eclipse.e4.core.commands.EHandlerService;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.slf4j.LoggerFactory;

public class HL7ImporterTaskResultDetailComposite {
    private ECommandService commandService;
    private EHandlerService handlerService;
    private IVirtualFilesystemService vfsService;
    private Button btnManualImport;
    private Button btnArchive;
    private Label lblStatus;
    private String fileUrl;

    public HL7ImporterTaskResultDetailComposite(final Composite parent, final ITask task, Map<String, Object> e4Services, IVirtualFilesystemService vfsService) {
        this.vfsService = vfsService;
        this.commandService = (ECommandService)e4Services.get(ECommandService.class.getName());
        this.handlerService = (EHandlerService)e4Services.get(EHandlerService.class.getName());
        this.fileUrl = (String)task.getResultEntryTyped("url", String.class);
        if (this.fileUrl == null) {
            this.fileUrl = (String)task.getRunContextEntryTyped("url", String.class);
        }
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout(2, false));
        container.setLayoutData((Object)new GridData(1808));
        this.lblStatus = new Label(container, 64);
        GridData gd_lblStatus = new GridData(4, 0x1000000, true, false, 2, 1);
        gd_lblStatus.heightHint = 60;
        this.lblStatus.setLayoutData((Object)gd_lblStatus);
        this.btnManualImport = new Button(container, 0);
        this.btnManualImport.setText("Datei manuell importieren");
        this.btnManualImport.setEnabled(this.fileUrl != null);
        this.btnManualImport.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String message;
                Map<String, String> params = Collections.singletonMap("ch.elexis.laborimport.hl7.allg.importFile.fileUrl", HL7ImporterTaskResultDetailComposite.this.fileUrl);
                ParameterizedCommand command = HL7ImporterTaskResultDetailComposite.this.commandService.createCommand("ch.elexis.laborimport.hl7.allg.importFile", params);
                Result result = (Result)HL7ImporterTaskResultDetailComposite.this.handlerService.executeHandler(command);
                if (result.isOK()) {
                    message = "Import erfolgreich.";
                } else {
                    message = (String)result.getMessages().get(0);
                    task.setStateCompletedManual("manual import");
                }
                MessageBox dialog = new MessageBox(parent.getShell(), result.isOK() ? 32 : 1);
                dialog.setText("Info");
                dialog.setMessage(message);
                dialog.open();
                HL7ImporterTaskResultDetailComposite.this.setTask(task);
            }
        });
        this.btnArchive = new Button(container, 0);
        this.btnArchive.setText("Datei archivieren");
        this.btnArchive.setEnabled(this.fileUrl != null);
        this.btnArchive.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String message;
                Map<String, String> params = Collections.singletonMap("ch.elexis.laborimport.hl7.allg.archiveFile.fileUrl", HL7ImporterTaskResultDetailComposite.this.fileUrl);
                ParameterizedCommand command = HL7ImporterTaskResultDetailComposite.this.commandService.createCommand("ch.elexis.laborimport.hl7.allg.archiveFile", params);
                Result result = (Result)HL7ImporterTaskResultDetailComposite.this.handlerService.executeHandler(command);
                if (result.isOK()) {
                    message = "Archivierung erfolgreich.";
                } else {
                    message = (String)result.getMessages().get(0);
                    task.setStateCompletedManual("manual archive");
                }
                MessageBox dialog = new MessageBox(parent.getShell(), result.isOK() ? 32 : 1);
                dialog.setText("Info");
                dialog.setMessage(message);
                dialog.open();
                HL7ImporterTaskResultDetailComposite.this.setTask(task);
            }
        });
        this.setTask(task);
    }

    private void setTask(ITask task) {
        String fileName;
        this.fileUrl = (String)task.getResultEntryTyped("url", String.class);
        IVirtualFilesystemService.IVirtualFilesystemHandle importFileHandle = null;
        try {
            importFileHandle = this.vfsService.of(this.fileUrl);
            fileName = importFileHandle.getName();
        }
        catch (IOException e) {
            fileName = e.getMessage();
            LoggerFactory.getLogger(this.getClass()).warn("Error parsing url", (Throwable)e);
        }
        StringBuilder text = new StringBuilder();
        if (task.isSucceeded()) {
            text.append("Die Datei [" + fileName + "] wurde erfolgreich importiert.");
        } else {
            text.append("Die Datei [" + fileName + "] konnte nicht automatisch importiert werden.");
            text.append("\n\n");
            text.append("Grund: " + (String)task.getResultEntryTyped("resultData", String.class) + "\n");
        }
        this.lblStatus.setText(text.toString());
        this.btnManualImport.setEnabled(!task.isSucceeded() && importFileHandle != null);
        this.btnArchive.setEnabled(!task.isSucceeded() && importFileHandle != null);
    }
}

