/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.reminder.part;

import ch.elexis.core.model.IContact;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.model.IReminder;
import ch.elexis.core.model.IUser;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.model.issue.ProcessStatus;
import ch.elexis.core.services.holder.ConfigServiceHolder;
import ch.elexis.core.services.holder.ContextServiceHolder;
import ch.elexis.core.services.holder.CoreModelServiceHolder;
import ch.elexis.core.ui.e4.util.CoreUiUtil;
import ch.elexis.core.ui.reminder.part.DragAndDropSupport;
import ch.elexis.core.ui.reminder.part.ReminderNatTableToolTip;
import ch.elexis.core.ui.reminder.part.ReminderTablesConfigLabelsAccumulator;
import ch.elexis.core.ui.reminder.part.ReminderTablesStyleConfiguration;
import ch.elexis.core.ui.reminder.part.SelectionUtil;
import ch.elexis.core.ui.reminder.part.nattable.RemiderRichTextUtil;
import ch.elexis.core.ui.reminder.part.nattable.ReminderBodyDataProvider;
import ch.elexis.core.ui.reminder.part.nattable.ReminderColumn;
import ch.elexis.core.ui.views.IRefreshable;
import jakarta.annotation.PostConstruct;
import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.e4.core.commands.ECommandService;
import org.eclipse.e4.core.commands.EHandlerService;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.di.UIEventTopic;
import org.eclipse.e4.ui.services.EMenuService;
import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.command.ILayerCommand;
import org.eclipse.nebula.widgets.nattable.config.AbstractUiBindingConfiguration;
import org.eclipse.nebula.widgets.nattable.config.CellConfigAttributes;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.config.IConfiguration;
import org.eclipse.nebula.widgets.nattable.coordinate.PositionCoordinate;
import org.eclipse.nebula.widgets.nattable.data.ISpanningDataProvider;
import org.eclipse.nebula.widgets.nattable.layer.DataLayer;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.ILayerListener;
import org.eclipse.nebula.widgets.nattable.layer.IUniqueIndexLayer;
import org.eclipse.nebula.widgets.nattable.layer.SpanningDataLayer;
import org.eclipse.nebula.widgets.nattable.layer.cell.IConfigLabelAccumulator;
import org.eclipse.nebula.widgets.nattable.layer.cell.ILayerCell;
import org.eclipse.nebula.widgets.nattable.layer.event.ILayerEvent;
import org.eclipse.nebula.widgets.nattable.resize.MaxCellBoundsHelper;
import org.eclipse.nebula.widgets.nattable.resize.command.MultiRowResizeCommand;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;
import org.eclipse.nebula.widgets.nattable.selection.action.SelectCellAction;
import org.eclipse.nebula.widgets.nattable.selection.event.CellSelectionEvent;
import org.eclipse.nebula.widgets.nattable.style.CellStyleAttributes;
import org.eclipse.nebula.widgets.nattable.style.DisplayMode;
import org.eclipse.nebula.widgets.nattable.style.Style;
import org.eclipse.nebula.widgets.nattable.ui.action.IMouseAction;
import org.eclipse.nebula.widgets.nattable.ui.binding.UiBindingRegistry;
import org.eclipse.nebula.widgets.nattable.ui.matcher.IMouseEventMatcher;
import org.eclipse.nebula.widgets.nattable.ui.matcher.MouseEventMatcher;
import org.eclipse.nebula.widgets.nattable.util.GCFactory;
import org.eclipse.nebula.widgets.nattable.util.ObjectUtils;
import org.eclipse.nebula.widgets.nattable.viewport.ViewportLayer;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.slf4j.LoggerFactory;

public class ReminderTablesPart
implements IRefreshable {
    private NatTable natTable;
    private ReminderBodyDataProvider dataProvider = new ReminderBodyDataProvider();
    private DataLayer dataLayer;
    @Inject
    private ECommandService commandService;
    @Inject
    private EHandlerService handlerService;
    private SelectionLayer selectionLayer;
    private ViewportLayer viewportLayer;
    private Text searchText;
    private SearchRunnable currentSearchRunnable;

    @Inject
    public ReminderTablesPart() {
    }

    @Optional
    @Inject
    void activePatient(IPatient patient) {
        this.refresh(false);
    }

    @Optional
    @Inject
    void activeUser(IUser user) {
        this.refresh();
    }

    @Optional
    @Inject
    void updateReminder(@UIEventTopic(value="info/elexis/model/update") IReminder reminder) {
        RemiderRichTextUtil.invalidateCache(reminder);
        this.refresh(false);
    }

    @Optional
    @Inject
    void createReminder(@UIEventTopic(value="info/elexis/model/create") IReminder reminder) {
        this.refresh(false);
    }

    @Optional
    @Inject
    void deleteReminder(@UIEventTopic(value="info/elexis/model/delete") IReminder reminder) {
        this.refresh(false);
    }

    @Optional
    @Inject
    void showCompleted(@UIEventTopic(value="reminder/showCompleted") Boolean value) {
        this.dataProvider.setShowCompleted(value);
        this.refresh(false);
    }

    @PostConstruct
    public void postConstruct(Composite parent, EMenuService menuService) {
        parent.setLayout((Layout)new GridLayout());
        this.searchText = new Text(parent, 2176);
        this.searchText.setLayoutData((Object)new GridData(4, 128, true, false));
        this.searchText.setMessage("Suche nach Titel");
        this.searchText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (StringUtils.isNotBlank((CharSequence)ReminderTablesPart.this.searchText.getText()) && ReminderTablesPart.this.searchText.getText().length() > 2) {
                    if (ReminderTablesPart.this.currentSearchRunnable != null) {
                        ReminderTablesPart.this.currentSearchRunnable.cancel();
                    }
                    ReminderTablesPart.this.currentSearchRunnable = new SearchRunnable(ReminderTablesPart.this.searchText.getText());
                    CompletableFuture.delayedExecutor(1000L, TimeUnit.MILLISECONDS).execute(ReminderTablesPart.this.currentSearchRunnable);
                } else {
                    this.resetSearch();
                }
            }

            private void resetSearch() {
                if (ReminderTablesPart.this.currentSearchRunnable != null) {
                    ReminderTablesPart.this.currentSearchRunnable.cancel();
                }
                if (ReminderTablesPart.this.dataProvider.getColumnCount() > 0 && ReminderTablesPart.this.dataProvider.getColumns().get(0).hasSearch()) {
                    ReminderTablesPart.this.dataProvider.getColumns().forEach(c -> c.setSearch(null));
                    ReminderTablesPart.this.refresh(true);
                }
            }
        });
        this.dataLayer = new SpanningDataLayer((ISpanningDataProvider)this.dataProvider);
        this.selectionLayer = new SelectionLayer((IUniqueIndexLayer)this.dataLayer);
        this.viewportLayer = new ViewportLayer((IUniqueIndexLayer)this.selectionLayer);
        this.viewportLayer.setRegionName("BODY");
        this.viewportLayer.setConfigLabelAccumulator((IConfigLabelAccumulator)new ReminderTablesConfigLabelsAccumulator(this.dataProvider, this.viewportLayer));
        this.dataProvider.setColumns(this.loadColumnsPreference());
        this.natTable = new NatTable(parent, 538184448, (ILayer)this.viewportLayer, false);
        this.natTable.setLayoutData((Object)new GridData(4, 4, true, true));
        this.natTable.setBackground(parent.getDisplay().getSystemColor(1));
        this.natTable.addConfiguration((IConfiguration)new ReminderTablesStyleConfiguration());
        this.addSelection();
        this.addTooltip();
        this.natTable.configure();
        this.updateColumns();
        DragAndDropSupport dndSupport = new DragAndDropSupport(this.natTable, this.selectionLayer, this.dataProvider);
        Transfer[] transfer = new Transfer[]{TextTransfer.getInstance()};
        this.natTable.addDragSupport(1, transfer, (DragSourceListener)dndSupport);
        this.natTable.addDropSupport(1, transfer, (DropTargetListener)dndSupport);
        menuService.registerContextMenu((Object)this.natTable, "ch.elexis.core.ui.reminder.popupmenu.remindertable");
        this.dataProvider.reload();
        Display.getDefault().asyncExec(() -> {
            if (CoreUiUtil.isActiveControl((Control)this.natTable)) {
                this.natTable.refresh();
            }
        });
    }

    public List<ReminderColumn> getColumns() {
        return new ArrayList<ReminderColumn>(this.dataProvider.getColumns());
    }

    public void setColumns(List<ReminderColumn> columns) {
        this.dataProvider.setColumns(columns);
        this.updateColumns();
        this.dataProvider.reload();
        Display.getDefault().asyncExec(() -> {
            if (CoreUiUtil.isActiveControl((Control)this.natTable)) {
                this.natTable.refresh();
            }
        });
        this.saveColumnsPreference();
    }

    private void saveColumnsPreference() {
        String columns = this.getColumns().stream().map(c -> c.getId()).collect(Collectors.joining("|"));
        ConfigServiceHolder.get().setActiveUserContact("ch.elexis.core.ui.reminder.part/columns", columns);
    }

    private List<ReminderColumn> loadColumnsPreference() {
        String names = ConfigServiceHolder.get().getActiveUserContact("ch.elexis.core.ui.reminder.part/columns", "");
        List<String> idParts = Arrays.asList(names.split("\\|"));
        ArrayList<ReminderColumn> ret = new ArrayList<ReminderColumn>();
        List<ReminderColumn> available = ReminderColumn.getAllAvailable();
        for (String id : idParts) {
            available.stream().filter(c -> c.getId().equals(id)).findFirst().ifPresent(c -> {
                boolean bl = ret.add((ReminderColumn)c);
            });
        }
        return ret;
    }

    private void addTooltip() {
        ReminderNatTableToolTip toolTip = new ReminderNatTableToolTip(this.natTable, this.dataProvider);
        toolTip.setPopupDelay(500);
        toolTip.activate();
        toolTip.setShift(new Point(10, 10));
    }

    private void addSelection() {
        this.natTable.addLayerListener(new ILayerListener(){

            public void handleLayerEvent(ILayerEvent event) {
                if (event instanceof CellSelectionEvent) {
                    CellSelectionEvent cellEvent = (CellSelectionEvent)event;
                    Integer columnPosition = ReminderTablesPart.this.natTable.getColumnIndexByPosition(cellEvent.getColumnPosition());
                    Integer rowPosition = ReminderTablesPart.this.natTable.getRowIndexByPosition(cellEvent.getRowPosition());
                    if (columnPosition >= 0 && rowPosition >= 0) {
                        Object data = ReminderTablesPart.this.dataProvider.getData(columnPosition, rowPosition);
                        if (data instanceof IReminder) {
                            ContextServiceHolder.get().setTyped(data);
                            if (ConfigServiceHolder.get().getActiveUserContact("reminder/autoSelectPatient", false)) {
                                IContact patient = ((IReminder)data).getContact();
                                IContact creator = ((IReminder)data).getCreator();
                                if (patient != null && patient.isPatient() && !patient.getId().equals(creator.getId())) {
                                    ContextServiceHolder.get().setActivePatient(patient.asIPatient());
                                }
                            }
                        } else {
                            ContextServiceHolder.get().removeTyped(IReminder.class);
                        }
                    } else {
                        ContextServiceHolder.get().removeTyped(IReminder.class);
                    }
                }
            }
        });
        this.natTable.addConfiguration((IConfiguration)new AbstractUiBindingConfiguration(){

            public void configureUiBindings(UiBindingRegistry uiBindingRegistry) {
                uiBindingRegistry.registerDoubleClickBinding((IMouseEventMatcher)new MouseEventMatcher(0, "BODY", 1), new IMouseAction(){

                    public void run(NatTable natTable, MouseEvent event) {
                        Object data = SelectionUtil.getData(natTable, (this).ReminderTablesPart.this.dataProvider, event.x, event.y);
                        if (data instanceof IReminder) {
                            ILayerCell cell = SelectionUtil.getCell(natTable, (this).ReminderTablesPart.this.dataProvider, event.x, event.y);
                            if (cell != null && SelectionUtil.isHoverCell(natTable, (this).ReminderTablesPart.this.dataProvider, cell, event.x, event.y)) {
                                if (SelectionUtil.isHoverCheck(natTable, (this).ReminderTablesPart.this.dataProvider, cell, event.x, event.y)) {
                                    IReminder reminder = (IReminder)data;
                                    if (reminder.getStatus() != ProcessStatus.CLOSED) {
                                        reminder.setStatus(ProcessStatus.CLOSED);
                                    } else {
                                        reminder.setStatus(ProcessStatus.OPEN);
                                    }
                                    CoreModelServiceHolder.get().save((Identifiable)reminder);
                                    ContextServiceHolder.get().postEvent("info/elexis/model/update", (Object)reminder);
                                    return;
                                }
                                ParameterizedCommand command = (this).ReminderTablesPart.this.commandService.createCommand("ch.elexis.core.ui.reminder.command.editReminder", null);
                                if (command != null) {
                                    (this).ReminderTablesPart.this.handlerService.executeHandler(command);
                                } else {
                                    LoggerFactory.getLogger(this.getClass()).error("Command not found");
                                }
                            }
                        } else {
                            int columnPosition = natTable.getColumnPositionByX(event.x);
                            if (columnPosition > -1) {
                                HashMap<String, String> parameters = new HashMap<String, String>();
                                ReminderColumn column = (this).ReminderTablesPart.this.dataProvider.getColumns().get(columnPosition);
                                switch (column.getType()) {
                                    case USER: {
                                        parameters.put("createReminder.responsible", column.getResponsible().getId());
                                        break;
                                    }
                                    case ALL: {
                                        parameters.put("createReminder.responsible", "Alle");
                                        break;
                                    }
                                    case GROUP: {
                                        parameters.put("createReminder.responsiblegroup", column.getGroup().getId());
                                        break;
                                    }
                                    case PATIENT: {
                                        if (column.getPatient() == null) break;
                                        parameters.put("createReminder.patient", column.getPatient().getId());
                                        break;
                                    }
                                    case POPUP: {
                                        parameters.put("createReminder.popup", Boolean.TRUE.toString());
                                        break;
                                    }
                                }
                                ParameterizedCommand command = (this).ReminderTablesPart.this.commandService.createCommand("ch.elexis.core.ui.reminder.command.createReminder", parameters);
                                if (command != null) {
                                    (this).ReminderTablesPart.this.handlerService.executeHandler(command);
                                } else {
                                    LoggerFactory.getLogger(this.getClass()).error("Command not found");
                                }
                            }
                        }
                    }
                });
                uiBindingRegistry.registerMouseDownBinding((IMouseEventMatcher)new MouseEventMatcher(0, null, 3), (IMouseAction)new SelectCellAction());
            }
        });
    }

    private void updateColumns() {
        for (ReminderColumn reminderColumn : this.dataProvider.getColumns()) {
            IConfigRegistry configRegistry = this.natTable.getConfigRegistry();
            Style columnStyle = new Style();
            columnStyle.setAttributeValue(CellStyleAttributes.BACKGROUND_COLOR, (Object)CoreUiUtil.getColorForString((String)reminderColumn.getColor()));
            configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_STYLE, (Object)columnStyle, DisplayMode.NORMAL, "BG_" + reminderColumn.getId());
        }
        this.resetColumns();
        this.dataLayer.setDefaultMinColumnWidth(50);
        this.dataLayer.setColumnPercentageSizing(true);
    }

    private void resetColumns() {
        this.dataLayer.setColumnPercentageSizing(false);
        this.dataLayer.resetColumnWidthConfiguration(true);
        this.dataLayer.resetRowHeightConfiguration(true);
    }

    private void refresh(boolean updateColumns) {
        if (this.dataProvider != null) {
            this.dataProvider.reload();
            Display.getDefault().asyncExec(() -> {
                if (CoreUiUtil.isActiveControl((Control)this.natTable)) {
                    if (updateColumns) {
                        this.updateColumns();
                    } else {
                        this.updateRowHeights();
                    }
                    PositionCoordinate[] selectedPositions = this.selectionLayer.getSelectedCellPositions();
                    this.natTable.refresh();
                    PositionCoordinate[] positionCoordinateArray = selectedPositions;
                    int n = selectedPositions.length;
                    int n2 = 0;
                    while (n2 < n) {
                        PositionCoordinate pos = positionCoordinateArray[n2];
                        this.selectionLayer.setSelectedCell(pos.columnPosition, pos.rowPosition);
                        ++n2;
                    }
                }
            });
        }
    }

    private void updateRowHeights() {
        ArrayList<Integer> positions = new ArrayList<Integer>();
        ArrayList<Integer> heights = new ArrayList<Integer>();
        int rowCount = this.viewportLayer.getRowCount();
        if (rowCount > 0) {
            int i = 0;
            while (i < rowCount) {
                int diff;
                int[] calculatedRowHeights;
                int[] rowPos = new int[1];
                int[] rowHeights = new int[1];
                rowPos[0] = this.viewportLayer.getRowIndexByPosition(i);
                rowHeights[0] = this.viewportLayer.getRowHeightByPosition(i);
                if (this.dataProvider.getData(0, rowPos[0]) instanceof String && rowPos[0] > 0 && (calculatedRowHeights = MaxCellBoundsHelper.getPreferredRowHeights((IConfigRegistry)this.natTable.getConfigRegistry(), (GCFactory)new GCFactory((Drawable)this.natTable), (ILayer)this.dataLayer, (int[])rowPos)) != null && calculatedRowHeights.length > 0 && calculatedRowHeights[0] >= 0 && ((diff = rowHeights[0] - calculatedRowHeights[0]) < -1 || diff > 1)) {
                    positions.add(rowPos[0]);
                    heights.add(calculatedRowHeights[0]);
                }
                ++i;
            }
        }
        if (!positions.isEmpty()) {
            this.dataLayer.doCommand((ILayerCommand)new MultiRowResizeCommand((ILayer)this.dataLayer, ObjectUtils.asIntArray(positions), ObjectUtils.asIntArray(heights), true));
        }
    }

    public void refresh() {
        this.refresh(true);
    }

    private class SearchRunnable
    implements Runnable {
        private String search;
        private boolean cancel;

        public SearchRunnable(String search) {
            this.search = search;
        }

        public void cancel() {
            this.cancel = true;
        }

        @Override
        public void run() {
            if (!this.cancel) {
                ReminderTablesPart.this.currentSearchRunnable = null;
                ReminderTablesPart.this.dataProvider.getColumns().forEach(c -> c.setSearch(this.search));
                ReminderTablesPart.this.refresh(true);
            }
        }
    }
}

