/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.reminder.part.nattable;

import ch.elexis.core.ui.util.FilterNonPrintableModifyListener;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.nebula.widgets.nattable.command.ILayerCommand;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.extension.nebula.richtext.RichTextCellPainter;
import org.eclipse.nebula.widgets.nattable.layer.cell.ILayerCell;
import org.eclipse.nebula.widgets.nattable.resize.command.ColumnResizeCommand;
import org.eclipse.nebula.widgets.nattable.resize.command.RowResizeCommand;
import org.eclipse.nebula.widgets.nattable.style.CellStyleAttributes;
import org.eclipse.nebula.widgets.nattable.style.CellStyleUtil;
import org.eclipse.nebula.widgets.nattable.style.IStyle;
import org.eclipse.nebula.widgets.nattable.style.VerticalAlignmentEnum;
import org.eclipse.nebula.widgets.nattable.util.GUIHelper;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.jsoup.Jsoup;

public class ReminderRichTextCellPainter
extends RichTextCellPainter {
    public ReminderRichTextCellPainter() {
        super(false, false, true);
    }

    public void paintCell(ILayerCell cell, GC gc, Rectangle bounds, IConfigRegistry configRegistry) {
        VerticalAlignmentEnum verticalAlignment;
        IStyle cellStyle = CellStyleUtil.getCellStyle((ILayerCell)cell, (IConfigRegistry)configRegistry);
        this.setupGCFromConfig(gc, cellStyle);
        String htmlText = this.getHtmlText(cell, configRegistry);
        Rectangle initialPainterBounds = new Rectangle(bounds.x, bounds.y - this.richTextPainter.getParagraphSpace(), bounds.width, bounds.height);
        Rectangle painterBounds = new Rectangle(bounds.x, bounds.y - this.richTextPainter.getParagraphSpace(), bounds.width, bounds.height);
        if (this.getPreferredSize((String)htmlText, (GC)gc, (ILayerCell)cell).x > painterBounds.width) {
            htmlText = this.abbreviateText(htmlText, gc, cell, painterBounds.width);
        }
        if ((verticalAlignment = (VerticalAlignmentEnum)cellStyle.getAttributeValue(CellStyleAttributes.VERTICAL_ALIGNMENT)) != VerticalAlignmentEnum.TOP) {
            this.richTextPainter.preCalculate(htmlText, gc, painterBounds, false);
            int contentHeight = this.richTextPainter.getPreferredSize().y - 2 * this.richTextPainter.getParagraphSpace();
            int verticalAlignmentPadding = CellStyleUtil.getVerticalAlignmentPadding((IStyle)cellStyle, (Rectangle)painterBounds, (int)contentHeight);
            painterBounds.y += verticalAlignmentPadding;
            painterBounds.height = contentHeight;
        }
        this.richTextPainter.paintHTML(htmlText, gc, painterBounds);
        int height = this.richTextPainter.getPreferredSize().y - 2 * this.richTextPainter.getParagraphSpace();
        if (this.performRowResize(height, initialPainterBounds)) {
            cell.getLayer().doCommand((ILayerCommand)new RowResizeCommand(cell.getLayer(), cell.getRowPosition(), GUIHelper.convertVerticalDpiToPixel((int)height, (IConfigRegistry)configRegistry) + (cell.getBounds().height - bounds.height)));
        }
        if (this.performColumnResize(this.richTextPainter.getPreferredSize().x, initialPainterBounds)) {
            cell.getLayer().doCommand((ILayerCommand)new ColumnResizeCommand(cell.getLayer(), cell.getColumnPosition(), GUIHelper.convertHorizontalDpiToPixel((int)this.richTextPainter.getPreferredSize().x, (IConfigRegistry)configRegistry) + (cell.getBounds().width - bounds.width)));
        }
    }

    private Point getPreferredSize(String htmlText, GC gc, ILayerCell cell) {
        this.richTextPainter.preCalculate(htmlText, gc, new Rectangle(0, 0, 0, cell.getBounds().height), false);
        return this.richTextPainter.getPreferredSize();
    }

    private String abbreviateText(String htmlText, GC gc, ILayerCell cell, int maxWidth) {
        String ret = FilterNonPrintableModifyListener.filterNonPrintable((String)htmlText);
        ret = ret.trim().replaceAll("\r\n", " ");
        ret = ret.trim().replaceAll(" +", " ");
        while (this.getPreferredSize((String)ret, (GC)gc, (ILayerCell)cell).x > maxWidth) {
            String maxText = this.getMaxText(ret).replaceAll("\u00a7", "'&sect;'").replaceAll("&", "&amp;");
            if (maxText.length() < 5) break;
            ret = ret.replace(maxText, StringUtils.abbreviate((String)maxText, (int)(maxText.length() - 1)));
        }
        return ret;
    }

    private String getMaxText(String ret) {
        if (ret.indexOf("!! </span></strong>") > 0) {
            ret = ret.substring(ret.indexOf("!! </span></strong>") + "!! </span></strong>".length());
        }
        String line1 = ret;
        String line2 = null;
        if (line1.indexOf("<br />") > 0) {
            line1 = ret.substring(0, ret.indexOf("<br />"));
            line2 = ret.substring(ret.indexOf("<br />") + "<br />".length());
            line1 = Jsoup.parse((String)line1).text();
            line2 = Jsoup.parse((String)line2).text();
        } else {
            line1 = Jsoup.parse((String)line1).text();
        }
        if (line2 != null) {
            return line1.length() >= line2.length() ? line1 : line2;
        }
        return line1;
    }

    protected String getHtmlText(ILayerCell cell, IConfigRegistry configRegistry) {
        String text = super.getHtmlText(cell, configRegistry);
        if (StringUtils.isNotBlank((CharSequence)text) && text.indexOf("<addition>") > -1) {
            text = text.substring(0, text.indexOf("<addition>"));
        }
        return text.replaceAll("\u00a7", "'&sect;'").replaceAll("&", "&amp;");
    }
}

