/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.reminder.part.nattable;

import ch.elexis.core.model.IPerson;
import ch.elexis.core.model.IReminder;
import ch.elexis.core.model.issue.Priority;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.time.format.DateTimeFormatter;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;

public class RemiderRichTextUtil {
    private static Cache<String, IReminder> cache = CacheBuilder.newBuilder().expireAfterAccess(15L, TimeUnit.SECONDS).build();

    public static String richText(IReminder reminder, boolean addDate) {
        StringBuilder sb = new StringBuilder();
        if (reminder.getPriority() == Priority.HIGH) {
            sb.append("<strong><span style=\"font-size: 14; color:rgb(255,0,0);\">");
            sb.append(" !! ");
            sb.append("</span></strong>");
        }
        sb.append("<strong>" + RemiderRichTextUtil.getSubject(reminder) + "</strong>").append("<br />");
        IReminder resolved = (IReminder)cache.getIfPresent((Object)reminder.getId());
        if (resolved != null) {
            if (resolved.getContact() != null && resolved.getContact().isPatient()) {
                sb.append(RemiderRichTextUtil.getPersonalia(resolved.getContact().asIPerson()));
            }
        } else {
            sb.append("...");
            CompletableFuture.runAsync(() -> {
                reminder.getContact();
                cache.put((Object)reminder.getId(), (Object)reminder);
            });
        }
        sb.append("<addition>");
        if (addDate && reminder.getDue() != null) {
            sb.append(DateTimeFormatter.ofPattern("dd.MM").format(reminder.getDue()));
        }
        sb.append("</addition>");
        return sb.toString();
    }

    private static String getPersonalia(IPerson person) {
        if (person != null) {
            StringBuilder sb = new StringBuilder(64);
            if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{person.getLastName()})) {
                sb.append(person.getLastName());
            }
            if (StringUtils.isNotBlank((CharSequence)sb.toString())) {
                sb.append(" ");
            }
            if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{person.getFirstName()})) {
                sb.append(person.getFirstName());
            }
            if (person.getDateOfBirth() != null) {
                if (StringUtils.isNotBlank((CharSequence)sb.toString())) {
                    sb.append(" ");
                }
                sb.append(DateTimeFormatter.ofPattern("dd.MM.yy").format(person.getDateOfBirth()));
            }
            return sb.toString();
        }
        return "";
    }

    private static String getSubject(IReminder reminder) {
        if (StringUtils.isNotBlank((CharSequence)reminder.getSubject())) {
            return reminder.getSubject();
        }
        if (StringUtils.isNotBlank((CharSequence)reminder.getMessage())) {
            return StringUtils.abbreviate((String)reminder.getMessage(), (int)80);
        }
        return "";
    }

    public static String richText(String string) {
        StringBuilder sb = new StringBuilder();
        sb.append("<strong>" + string + "</strong>");
        return sb.toString();
    }

    public static String richText(String string, int increaseFontSize) {
        StringBuilder sb = new StringBuilder();
        int size = 14 + increaseFontSize;
        sb.append("<p style=\"width: 100%;text-align: center\">");
        sb.append("<span style=\"font-size: " + size + "\">");
        sb.append("<strong>" + string + "</strong>");
        sb.append("</span>");
        sb.append("</p>");
        return sb.toString();
    }

    public static void invalidateCache(IReminder reminder) {
        cache.invalidate((Object)reminder.getId());
    }
}

