/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.reminder.menu;

import ch.elexis.core.model.IReminder;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.model.issue.Priority;
import ch.elexis.core.services.holder.ContextServiceHolder;
import ch.elexis.core.services.holder.CoreModelServiceHolder;
import java.util.List;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.ui.di.AboutToShow;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.menu.ItemType;
import org.eclipse.e4.ui.model.application.ui.menu.MDirectMenuItem;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuElement;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuFactory;

public class ImportantMenuContribution {
    @AboutToShow
    public void aboutToShow(MPart mpart, List<MMenuElement> items) {
        ContextServiceHolder.get().getTyped(IReminder.class).ifPresent(r -> {
            MDirectMenuItem dynamicItem = MMenuFactory.INSTANCE.createDirectMenuItem();
            dynamicItem.setType(ItemType.CHECK);
            dynamicItem.setLabel("Wichtig");
            dynamicItem.setContributionURI("bundleclass://ch.elexis.core.ui.reminder/" + this.getClass().getName());
            dynamicItem.setSelected(r.getPriority() == Priority.HIGH);
            dynamicItem.setEnabled(true);
            dynamicItem.getTransientData().put("reminder", r);
            items.add((MMenuElement)dynamicItem);
        });
    }

    @Execute
    private void toggleMine(MPart mpart, MDirectMenuItem menuItem) {
        IReminder reminder;
        reminder.setPriority((reminder = (IReminder)menuItem.getTransientData().get("reminder")).getPriority() == Priority.HIGH ? Priority.MEDIUM : Priority.HIGH);
        CoreModelServiceHolder.get().save((Identifiable)reminder);
        ContextServiceHolder.get().postEvent("info/elexis/model/update", (Object)reminder);
    }
}

