/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.perspective.service.internal;

import ch.elexis.core.ui.compatibility.ElexisFastViewUtil;
import ch.elexis.core.ui.perspective.service.IPerspectiveExportService;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import org.eclipse.e4.ui.internal.workbench.E4XMIResourceFactory;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.advanced.MPerspective;
import org.eclipse.e4.ui.model.application.ui.advanced.MPlaceholder;
import org.eclipse.e4.ui.model.application.ui.basic.MTrimmedWindow;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.ui.PlatformUI;
import org.osgi.service.component.annotations.Component;

@Component
public class PerspectiveExportService
implements IPerspectiveExportService {
    private static <T> T getService(Class<T> clazz) {
        return (T)PlatformUI.getWorkbench().getService(clazz);
    }

    private static MPerspective clonePerspectiveWithWorkaround(EModelService modelService, MPerspective original) {
        MPerspective clone = (MPerspective)modelService.cloneElement((MUIElement)original, null);
        clone.setElementId(original.getElementId());
        List placeholderClones = modelService.findElements((MUIElement)clone, null, MPlaceholder.class, null, 4);
        for (MPlaceholder placeholderClone : placeholderClones) {
            List placeholderOriginal = modelService.findElements((MUIElement)original, placeholderClone.getElementId(), MPlaceholder.class, null, 4);
            if (placeholderOriginal.size() == 1) {
                placeholderClone.setRef(((MPlaceholder)placeholderOriginal.get(0)).getRef());
                continue;
            }
            if (placeholderOriginal.isEmpty()) {
                System.out.println("NO PLACEHOLDER");
                continue;
            }
            System.out.println("MORE THEN ONE PLACEHOLDER " + placeholderOriginal.toString());
            placeholderClone.setRef(((MPlaceholder)placeholderOriginal.get(0)).getRef());
        }
        return clone;
    }

    @Override
    public void exportPerspective(String pathToExport, String newCode, String newLabel) throws IOException {
        Throwable throwable = null;
        Object var5_6 = null;
        try (FileOutputStream outputStream = new FileOutputStream(pathToExport);){
            List windows;
            EModelService modelService = PerspectiveExportService.getService(EModelService.class);
            MApplication mApplication = PerspectiveExportService.getService(MApplication.class);
            MTrimmedWindow window = (MTrimmedWindow)modelService.find("IDEWindow", (MUIElement)mApplication);
            if (window == null && !(windows = mApplication.getChildren()).isEmpty() && windows.get(0) instanceof MTrimmedWindow) {
                window = (MTrimmedWindow)windows.get(0);
            }
            MPerspective activePerspective = modelService.getActivePerspective((MWindow)window);
            E4XMIResourceFactory e4xmiResourceFactory = new E4XMIResourceFactory();
            Resource resource = e4xmiResourceFactory.createResource(null);
            MPerspective clone = PerspectiveExportService.clonePerspectiveWithWorkaround(modelService, activePerspective);
            if (newLabel != null) {
                clone.setLabel(newLabel);
            }
            if (newCode != null) {
                clone.setElementId(newCode);
            }
            List placeholderClones = modelService.findElements((MUIElement)clone, null, MPlaceholder.class, null, 4);
            for (MPlaceholder placeholder : placeholderClones) {
                placeholder.setRef(null);
            }
            ElexisFastViewUtil.transferFastViewPersistedState((MTrimmedWindow)window, (MPerspective)clone);
            resource.getContents().add((Object)((EObject)clone));
            resource.save((OutputStream)outputStream, null);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

