/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.mediorder;

import ch.elexis.core.model.IStock;
import java.time.format.DateTimeFormatter;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;

public class MediorderStockFilter
extends ViewerFilter {
    private String searchTerm;
    private DateTimeFormatter dateFormatter;

    public void setSearchTerm(String term) {
        this.searchTerm = ".*" + term.toLowerCase() + ".*";
    }

    public boolean select(Viewer viewer, Object parentElement, Object element) {
        if (this.searchTerm == null || this.searchTerm.length() == 0) {
            return true;
        }
        IStock stock = (IStock)element;
        String patientId = stock.getOwner().asIPatient().getPatientNr().toLowerCase();
        if (patientId.matches(this.searchTerm)) {
            return true;
        }
        String firstName = stock.getOwner().getFirstName().toLowerCase();
        if (firstName.matches(this.searchTerm)) {
            return true;
        }
        String lastName = stock.getOwner().getLastName().toLowerCase();
        if (lastName.matches(this.searchTerm)) {
            return true;
        }
        this.dateFormatter = DateTimeFormatter.ofPattern("dd.MM.yyyy");
        String birthDate = stock.getOwner().getDateOfBirth().format(this.dateFormatter).toLowerCase();
        return birthDate.matches(this.searchTerm);
    }
}

