/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.mediorder;

import ch.elexis.core.mediorder.MediorderEntryState;
import ch.elexis.core.mediorder.MediorderUtil;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.model.IPrescription;
import ch.elexis.core.model.IStock;
import ch.elexis.core.model.IStockEntry;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.model.prescription.EntryType;
import ch.elexis.core.services.IContextService;
import ch.elexis.core.services.IModelService;
import ch.elexis.core.services.IStockService;
import ch.elexis.core.services.holder.MedicationServiceHolder;
import ch.elexis.core.services.holder.StockServiceHolder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MediorderPartUtil {
    public static String createMediorderEntryOutreachLabel(Object object) {
        if (object instanceof IStockEntry) {
            IStockEntry stockEntry = (IStockEntry)object;
            Double resultDays = null;
            IPatient patient = stockEntry.getStock().getOwner().asIPatient();
            List lMedication = patient.getMedication(Arrays.asList(EntryType.FIXED_MEDICATION, EntryType.RESERVE_MEDICATION, EntryType.SYMPTOMATIC_MEDICATION));
            for (IPrescription prescription : lMedication) {
                if (!prescription.getArticle().equals(stockEntry.getArticle())) continue;
                float dailyDosageAsFloat = MedicationServiceHolder.get().getDailyDosageAsFloat(prescription);
                int maximumStock = stockEntry.getMaximumStock();
                resultDays = Math.floor((float)(stockEntry.getArticle().getPackageSize() * maximumStock) / dailyDosageAsFloat);
            }
            return resultDays != null ? String.valueOf(resultDays.intValue()) + " Tage" : "";
        }
        return "?";
    }

    public static String createMediorderEntryStateLabel(Object object) {
        if (object instanceof IStockEntry) {
            IStockEntry stockEntry = (IStockEntry)object;
            return MediorderUtil.determineState((IStockEntry)stockEntry).getLocaleText();
        }
        return "?";
    }

    public static void removeStockEntry(IStockEntry entry, IModelService coreModelService, IContextService contextService, IStockService stockService) {
        if (entry.getCurrentStock() > 0) {
            String mandatorId = contextService.getActiveMandator().map(Identifiable::getId).orElse(null);
            if (mandatorId == null) {
                return;
            }
            stockService.performSingleReturn(entry.getArticle(), entry.getCurrentStock(), mandatorId);
        }
        coreModelService.remove((Identifiable)entry);
        IStock stock = entry.getStock();
        if (stock.getStockEntries().isEmpty()) {
            coreModelService.remove((Identifiable)stock);
        }
    }

    public static void updateStockImageState(Map<IStock, Integer> imageStockStates, IStock stock) {
        int state = MediorderUtil.calculateStockState((IStock)stock);
        imageStockStates.put(stock, state);
    }

    public static int getImageForStock(Map<IStock, Integer> imageStockStates, IStock stock) {
        return imageStockStates.computeIfAbsent(stock, MediorderUtil::calculateStockState);
    }

    public static List<IStock> calculateFilteredStocks(List<Integer> filterValues) {
        HashMap<IStock, Integer> map = new HashMap<IStock, Integer>();
        List stocks = StockServiceHolder.get().getAllPatientStock();
        for (IStock stock : stocks) {
            map.computeIfAbsent(stock, MediorderUtil::calculateStockState);
        }
        ArrayList<IStock> filteredList = new ArrayList<IStock>();
        for (Map.Entry entry : map.entrySet()) {
            if (entry.getValue() == null || !filterValues.contains(entry.getValue())) continue;
            filteredList.add((IStock)entry.getKey());
        }
        return filteredList;
    }

    public static void automaticallyFromDefaultStock(IStockEntry entry, IStockService stockService, IModelService coreModelService, IContextService contextService) {
        IStockEntry defaultStockEntry = stockService.findStockEntryForArticleInStock(stockService.getDefaultStock(), entry.getArticle());
        if (defaultStockEntry == null || defaultStockEntry.getCurrentStock() == 0) {
            return;
        }
        if (MediorderEntryState.REQUESTED.equals((Object)MediorderUtil.determineState((IStockEntry)entry))) {
            int amount = Math.min(defaultStockEntry.getCurrentStock(), entry.getMinimumStock());
            MediorderPartUtil.useFromDefaultStock(entry, defaultStockEntry, amount, stockService, coreModelService, contextService);
        }
    }

    protected static String[] createValuesArray(IStockEntry entry, IStockService stockService) {
        IStockEntry defaultStockEntry = stockService.findStockEntryForArticleInStock(stockService.getDefaultStock(), entry.getArticle());
        int maxValue = Math.min((defaultStockEntry != null ? defaultStockEntry.getCurrentStock() : 0) + entry.getCurrentStock(), entry.getMaximumStock());
        ArrayList<String> values = new ArrayList<String>();
        int i = 0;
        while (i <= maxValue) {
            values.add(String.valueOf(i));
            ++i;
        }
        return values.toArray(new String[0]);
    }

    public static void useFromDefaultStock(IStockEntry entry, IStockEntry article, int amount, IStockService stockService, IModelService coreModelService, IContextService contextService) {
        String mandatorId = contextService.getActiveMandator().map(Identifiable::getId).orElse(null);
        if (mandatorId == null) {
            return;
        }
        int difference = amount - entry.getCurrentStock();
        if (difference > 0) {
            stockService.performSingleDisposal(article.getArticle(), difference, mandatorId);
        } else if (difference < 0) {
            stockService.performSingleReturn(article.getArticle(), difference *= -1, mandatorId);
        }
        entry.setCurrentStock(amount);
        coreModelService.save((Identifiable)article);
        coreModelService.save((Identifiable)entry);
    }
}

