/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.medication.views;

import ch.elexis.core.model.IArticle;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.model.IPrescription;
import ch.elexis.core.model.ModelPackage;
import ch.elexis.core.model.prescription.EntryType;
import ch.elexis.core.services.IQuery;
import ch.elexis.core.services.holder.CoreModelServiceHolder;
import ch.elexis.core.services.holder.MedicationServiceHolder;
import ch.elexis.core.ui.medication.views.Messages;
import ch.elexis.core.ui.medication.views.ViewerSortOrder;
import ch.rgw.tools.Money;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.State;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.slf4j.LoggerFactory;

public class MedicationViewHelper {
    private static final int FILTER_PRESCRIPTION_AFTER_N_DAYS = 30;

    public static ViewerSortOrder getSelectedComparator() {
        ICommandService service = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
        Command command = service.getCommand("ch.elexis.core.ui.medication.ApplyCustomSorting");
        State state = command.getState("org.eclipse.ui.commands.toggleState");
        if (((Boolean)state.getValue()).booleanValue()) {
            return ViewerSortOrder.getSortOrderPerValue(ViewerSortOrder.MANUAL.val);
        }
        return ViewerSortOrder.getSortOrderPerValue(ViewerSortOrder.DEFAULT.val);
    }

    public static String calculateDailyCostAsString(List<IPrescription> prescriptions) {
        String TTCOST = Messages.FixMediDisplay_DailyCost;
        double cost = 0.0;
        boolean canCalculate = true;
        for (IPrescription prescription : prescriptions) {
            float num = MedicationServiceHolder.get().getDailyDosageAsFloat(prescription);
            try {
                IArticle article = prescription.getArticle();
                if (article != null) {
                    int ve = article.getPackageSize();
                    if (ve != 0) {
                        Money price = article.getSellingPrice();
                        if (price == null) continue;
                        cost += (double)num * price.getAmount() / (double)ve;
                        continue;
                    }
                    canCalculate = false;
                    continue;
                }
                canCalculate = false;
            }
            catch (Exception ex) {
                LoggerFactory.getLogger(MedicationViewHelper.class).warn("Error calculating daily cost of prescription", (Throwable)ex);
                canCalculate = false;
            }
        }
        double rounded = (double)Math.round(100.0 * cost) / 100.0;
        if (canCalculate) {
            return TTCOST + " " + Double.toString(rounded);
        }
        if (rounded == 0.0) {
            return TTCOST + " ?";
        }
        return TTCOST + " >" + Double.toString(rounded);
    }

    public static List<IArticle> getAllGtins(List<IPrescription> pres) {
        ArrayList<IArticle> gtins = new ArrayList<IArticle>();
        for (IPrescription pr : pres) {
            IArticle art = pr.getArticle();
            if (art == null || gtins.contains(art)) continue;
            gtins.add(art);
        }
        return gtins;
    }

    public static List<IPrescription> loadInputData(boolean loadFullHistory, IPatient patient) {
        if (patient == null) {
            return Collections.emptyList();
        }
        if (loadFullHistory) {
            return MedicationViewHelper.loadAllHistorical(patient);
        }
        return MedicationViewHelper.loadNonHistorical(patient);
    }

    private static List<IPrescription> loadNonHistorical(IPatient patient) {
        if (patient != null) {
            List tmpPrescs = patient.getMedication(Arrays.asList(EntryType.FIXED_MEDICATION, EntryType.RESERVE_MEDICATION, EntryType.SYMPTOMATIC_MEDICATION));
            ArrayList<IPrescription> result = new ArrayList<IPrescription>();
            for (IPrescription p : tmpPrescs) {
                if (p.getArticle() != null && p.getArticle().getAtcCode() != null && p.getArticle().isVaccination()) continue;
                result.add(p);
            }
            return result;
        }
        return Collections.emptyList();
    }

    private static List<IPrescription> loadAllHistorical(IPatient patient) {
        IQuery query = CoreModelServiceHolder.get().getQuery(IPrescription.class);
        query.and((EStructuralFeature)ModelPackage.Literals.IPRESCRIPTION__PATIENT, IQuery.COMPARATOR.EQUALS, (Object)patient);
        query.orderBy((EStructuralFeature)ModelPackage.Literals.IPRESCRIPTION__DATE_FROM, IQuery.ORDER.DESC);
        return query.execute();
    }
}

