/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.medication.views;

import ch.elexis.core.model.IArticle;
import ch.elexis.core.model.IBilled;
import ch.elexis.core.model.IContact;
import ch.elexis.core.model.IPrescription;
import ch.elexis.core.model.IRecipe;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.model.prescription.EntryType;
import ch.elexis.core.services.holder.CoreModelServiceHolder;
import ch.elexis.core.ui.icons.Images;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Control;

public class MedicationTableViewerItem {
    private static DateTimeFormatter dateFormatter = DateTimeFormatter.ofPattern("dd.MM.yyyy");
    private static ExecutorService executorService = Executors.newFixedThreadPool(8);
    private StructuredViewer viewer;
    private IPrescription prescription;
    private IArticle article;
    private LocalDateTime dateFrom;
    private LocalDateTime dateUntil;
    private String dosis;
    private String remark;
    private String disposalComment;
    private int sortOrder;
    private IContact prescriptor;
    private String artikelLabel;
    private Identifiable lastDisposed;
    private String prescriptorLabel;
    private String stopReason;
    private Image image;
    private Date endTime;
    private boolean resolved = false;
    private boolean resolving = false;

    private MedicationTableViewerItem(IPrescription prescription, StructuredViewer viewer) {
        this.viewer = viewer;
        this.prescription = prescription;
        this.article = prescription.getArticle();
        this.dosis = prescription.getDosageInstruction();
        this.remark = prescription.getRemark();
        this.sortOrder = prescription.getSortOrder();
        this.prescriptor = prescription.getPrescriptor();
        this.dateFrom = prescription.getDateFrom();
        this.dateUntil = prescription.getDateTo();
        this.endTime = this.dateUntil != null ? Date.from(this.dateUntil.atZone(ZoneId.systemDefault()).toInstant()) : new Date();
    }

    public static List<MedicationTableViewerItem> createFromPrescriptionList(List<IPrescription> prescriptionList, StructuredViewer viewer) {
        List<MedicationTableViewerItem> collect = prescriptionList.stream().map(p -> new MedicationTableViewerItem((IPrescription)p, viewer)).collect(Collectors.toList());
        return collect;
    }

    public String getId() {
        return this.prescription.getId();
    }

    public String getBeginDate() {
        return this.dateFrom != null ? dateFormatter.format(this.dateFrom) : "";
    }

    public String getEndDate() {
        return this.dateUntil != null ? dateFormatter.format(this.dateUntil) : "";
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public void setEndTime(Date time) {
        this.endTime = time;
    }

    public String getDosis() {
        return this.dosis != null ? this.dosis : "";
    }

    public IPrescription getPrescription() {
        return this.prescription;
    }

    public String getStopReason() {
        if (this.stopReason == null && !this.resolved && !this.resolving) {
            this.resolving = true;
            executorService.execute(new ResolveLazyFieldsRunnable(this.viewer, this));
        }
        return this.stopReason != null ? this.stopReason : "...";
    }

    public String getRemark() {
        return this.remark;
    }

    public String getDisposalComment() {
        if (this.disposalComment == null && !this.resolved && !this.resolving) {
            this.resolving = true;
            executorService.execute(new ResolveLazyFieldsRunnable(this.viewer, this));
        }
        return this.disposalComment != null ? this.disposalComment : "...";
    }

    public IArticle getArticle() {
        return this.article;
    }

    public boolean isActiveMedication() {
        EntryType entryType = this.prescription.getEntryType();
        return entryType != EntryType.RECIPE && entryType != EntryType.SELF_DISPENSED && !this.isStopped();
    }

    public Identifiable getLastDisposed() {
        if (this.lastDisposed == null && !this.resolved && !this.resolving) {
            this.resolving = true;
            executorService.execute(new ResolveLazyFieldsRunnable(this.viewer, this));
        }
        return this.lastDisposed;
    }

    public String getAtc() {
        if (this.article != null) {
            return this.article.getAtcCode();
        }
        return "?";
    }

    public EntryType getEntryType() {
        return this.prescription.getEntryType();
    }

    public String getArtikelLabel() {
        if (this.artikelLabel == null && !this.resolved && !this.resolving) {
            this.resolving = true;
            executorService.execute(new ResolveLazyFieldsRunnable(this.viewer, this));
        }
        return this.artikelLabel != null ? this.artikelLabel : "...";
    }

    public void setOrder(int i) {
        this.sortOrder = i;
        this.prescription.setSortOrder(i);
        CoreModelServiceHolder.get().save((Identifiable)this.prescription);
    }

    public int getOrder() {
        return this.sortOrder;
    }

    public boolean isStopped() {
        return this.dateUntil != null;
    }

    public String getPrescriptorLabel() {
        if (this.prescriptorLabel == null && !this.resolved && !this.resolving) {
            this.resolving = true;
            executorService.execute(new ResolveLazyFieldsRunnable(this.viewer, this));
        }
        return this.prescriptorLabel != null ? this.prescriptorLabel : "...";
    }

    public Image getImage() {
        if (this.image == null && !this.resolved && !this.resolving) {
            this.resolving = true;
            executorService.execute(new ResolveLazyFieldsRunnable(this.viewer, this));
        }
        return this.image != null ? this.image : Images.IMG_EMPTY_TRANSPARENT.getImage();
    }

    public void resolve() {
        if (!this.resolved) {
            new ResolveLazyFieldsRunnable(null, this).run();
        }
    }

    public IRecipe getRecipe() {
        return this.prescription.getRecipe();
    }

    public IBilled getBilled() {
        return this.prescription.getBilled();
    }

    private static class ResolveLazyFieldsRunnable
    implements Runnable {
        private MedicationTableViewerItem item;
        private StructuredViewer viewer;

        public ResolveLazyFieldsRunnable(StructuredViewer viewer, MedicationTableViewerItem item) {
            this.item = item;
            this.viewer = viewer;
        }

        @Override
        public void run() {
            this.resolveImage();
            this.resolveArticleLabel();
            this.resolveLastDisposed();
            this.resolveStopReason();
            this.resolvePrescriptorLabel();
            this.resolveDisposalComment();
            this.item.resolved = true;
            this.item.resolving = false;
            this.updateViewer();
        }

        private void updateViewer() {
            Control control;
            if (this.viewer != null && (control = this.viewer.getControl()) != null && !control.isDisposed()) {
                this.viewer.getControl().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (!control.isDisposed() && control.isVisible()) {
                            viewer.update((Object)item, null);
                        }
                    }
                });
            }
        }

        private void resolveArticleLabel() {
            this.item.artikelLabel = this.item.article != null ? this.item.article.getLabel() : "?";
        }

        private void resolveImage() {
            EntryType et = this.item.prescription.getEntryType();
            switch (et) {
                case FIXED_MEDICATION: {
                    this.item.image = Images.IMG_FIX_MEDI.getImage();
                    break;
                }
                case RESERVE_MEDICATION: {
                    this.item.image = Images.IMG_RESERVE_MEDI.getImage();
                    break;
                }
                case SYMPTOMATIC_MEDICATION: {
                    this.item.image = Images.IMG_SYMPTOM_MEDI.getImage();
                    break;
                }
                case SELF_DISPENSED: {
                    if (this.item.prescription.isApplied()) {
                        this.item.image = Images.IMG_SYRINGE.getImage();
                        break;
                    }
                    this.item.image = Images.IMG_VIEW_CONSULTATION_DETAIL.getImage();
                    break;
                }
                case RECIPE: {
                    this.item.image = Images.IMG_VIEW_RECIPES.getImage();
                    break;
                }
                default: {
                    this.item.image = Images.IMG_EMPTY_TRANSPARENT.getImage();
                }
            }
        }

        private void resolveLastDisposed() {
            IRecipe recipe = this.item.prescription.getRecipe();
            IBilled billed = this.item.prescription.getBilled();
            if (recipe != null) {
                this.item.lastDisposed = recipe;
            } else if (billed != null && billed.getEncounter() != null) {
                this.item.lastDisposed = billed;
            }
        }

        private void resolveStopReason() {
            String reason = this.item.prescription.getStopReason();
            this.item.stopReason = reason != null ? reason : "";
        }

        private void resolvePrescriptorLabel() {
            this.item.prescriptorLabel = "";
            if (this.item.prescriptor != null) {
                this.item.prescriptorLabel = this.item.prescriptor.getLabel();
            }
        }

        private void resolveDisposalComment() {
            String comment = this.item.prescription.getDisposalComment();
            this.item.disposalComment = comment != null ? comment : "";
        }
    }
}

