/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.medication.preferences;

import ch.elexis.core.l10n.Messages;
import ch.elexis.core.ui.medication.views.MedicationView;
import ch.elexis.core.ui.medication.views.ViewerSortOrder;
import ch.elexis.core.ui.preferences.ConfigServicePreferenceStore;
import ch.elexis.core.ui.preferences.inputs.MultilineFieldEditor;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;

public class MedicationSettings
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    private BooleanFieldEditor sortingFieldEditor;
    private BooleanFieldEditor predefinedSymptomDaysFieldEditor;
    private IntegerFieldEditor symptomDurationFieldEditor;

    public MedicationSettings() {
        super(1);
        this.setPreferenceStore((IPreferenceStore)new ConfigServicePreferenceStore(ConfigServicePreferenceStore.Scope.USER));
        this.getPreferenceStore().setDefault("medication/settings/emediplanHeaderComment", Messages.Medication_headerComment);
    }

    protected void createFieldEditors() {
        this.addField((FieldEditor)new BooleanFieldEditor("medication/settings/alwaysShowSignatureDialog", Messages.MedicationSettings_ShowSignatureDialog, this.getFieldEditorParent()));
        this.addField((FieldEditor)new BooleanFieldEditor("medication/settings/signatureStdDispensation", Messages.MedicationSettings_PreselectSignatureDispensation, this.getFieldEditorParent()));
        this.addField((FieldEditor)new BooleanFieldEditor("medication/settings/artikelstammConvert", Messages.MedicationSettings_CheckAndConvertItemMaster, this.getFieldEditorParent()));
        this.sortingFieldEditor = new BooleanFieldEditor("medication/settings/showPersonalSort", Messages.MedicationSettings_ShowCustomSorting, this.getFieldEditorParent());
        this.addField((FieldEditor)this.sortingFieldEditor);
        this.addField((FieldEditor)new BooleanFieldEditor("anwender/suppressintractioncheck", Messages.UserSettings2_SuppressInteractionCheck, this.getFieldEditorParent()));
        this.addField((FieldEditor)new BooleanFieldEditor("medication/settings/showDialogOnBilling", Messages.Medication_SettingsShowDialogOnBilling, this.getFieldEditorParent()));
        this.predefinedSymptomDaysFieldEditor = new BooleanFieldEditor("medicationSettingsDefaultSymptoms", Messages.MedicationSettings_EnablePredefinedSymptomDays, this.getFieldEditorParent());
        this.addField((FieldEditor)this.predefinedSymptomDaysFieldEditor);
        this.getPreferenceStore().setDefault("medicationSettingsSymptomDuration", 30);
        this.symptomDurationFieldEditor = new IntegerFieldEditor("medicationSettingsSymptomDuration", Messages.MedicationSettings_NumberOfStopDays, this.getFieldEditorParent(), 3);
        this.symptomDurationFieldEditor.setEnabled(this.getPreferenceStore().getBoolean("medicationSettingsDefaultSymptoms"), this.getFieldEditorParent());
        this.addField((FieldEditor)this.symptomDurationFieldEditor);
        this.addField((FieldEditor)new MultilineFieldEditor("medication/settings/emediplanHeaderComment", Messages.MedicationSettings_ShowCommentOnEMediplan, this.getFieldEditorParent()));
    }

    public void propertyChange(PropertyChangeEvent event) {
        MedicationView view;
        super.propertyChange(event);
        if (event.getSource() == this.predefinedSymptomDaysFieldEditor) {
            boolean enabled = (Boolean)event.getNewValue();
            this.symptomDurationFieldEditor.setEnabled(enabled, this.getFieldEditorParent());
        }
        if (event.getSource() == this.sortingFieldEditor && (view = (MedicationView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findView("ch.elexis.core.ui.medication.views.MedicationView")) != null && event.getNewValue() == Boolean.FALSE) {
            view.setMedicationTableViewerComparator(ViewerSortOrder.DEFAULT);
        }
    }

    public void init(IWorkbench workbench) {
    }
}

