/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.medication.views;

import ch.elexis.core.model.IPrescription;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.services.holder.ContextServiceHolder;
import ch.elexis.core.ui.medication.views.MedicationComposite;
import ch.elexis.core.ui.medication.views.MedicationTableViewerContentProvider;
import ch.elexis.core.ui.medication.views.MedicationTableViewerItem;
import ch.elexis.core.ui.medication.views.MedicationViewerHelper;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.NotEnabledException;
import org.eclipse.core.commands.NotHandledException;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.IHandlerService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MedicationTableComposite
extends Composite {
    private static Logger log = LoggerFactory.getLogger(MedicationTableComposite.class);
    private TableViewer viewer;
    private TableColumnLayout layout;
    private MedicationComposite medicationComposite;
    private List<IPrescription> pendingInput;

    public MedicationTableComposite(Composite parent, int style) {
        super(parent, style);
        this.setLayoutData(new GridData(4, 4, true, true, 1, 1));
        this.layout = new TableColumnLayout();
        this.setLayout((Layout)this.layout);
        this.viewer = new TableViewer((Composite)this, 65538);
        this.viewer.getTable().setHeaderVisible(true);
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.viewer, (int)2);
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent e) {
                IStructuredSelection is = (IStructuredSelection)MedicationTableComposite.this.viewer.getSelection();
                MedicationTableViewerItem presc = (MedicationTableViewerItem)is.getFirstElement();
                Identifiable identifiable = presc != null ? presc.getLastDisposed() : null;
                MedicationTableComposite.this.medicationComposite.setLastDisposal(identifiable);
                MedicationTableComposite.this.medicationComposite.setSelectedMedication(presc);
                if (presc != null) {
                    IPrescription selectedObj = presc.getPrescription();
                    ContextServiceHolder.get().getRootContext().setTyped((Object)selectedObj);
                } else {
                    ContextServiceHolder.get().getRootContext().removeTyped(IPrescription.class);
                }
            }
        });
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                StructuredSelection ss = (StructuredSelection)event.getSelection();
                if (ss != null && !ss.isEmpty()) {
                    try {
                        IHandlerService handlerService = (IHandlerService)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getService(IHandlerService.class);
                        handlerService.executeCommand("ch.elexis.core.ui.medication.OpenArticelDetailDialog", null);
                    }
                    catch (ExecutionException | NotEnabledException | NotHandledException | NotDefinedException e) {
                        MessageDialog.openError((Shell)MedicationTableComposite.this.getShell(), (String)"Fehler", (String)"Eigenschaften konnten nicht ge\u00f6ffnet werden.");
                        log.error("cannot open article detail dialog", e);
                    }
                }
            }
        });
        MedicationViewerHelper.createTypeColumn(this.viewer, this.layout, 0);
        MedicationViewerHelper.createArticleColumn(this.viewer, this.layout, 1);
        MedicationViewerHelper.createDosageColumn(this.viewer, this.layout, 2);
        MedicationViewerHelper.createBeginColumn(this.viewer, this.layout, 3);
        MedicationViewerHelper.createIntakeCommentColumn(this.viewer, this.layout, 4);
        MedicationViewerHelper.createDisposalCommentColumn(this.viewer, this.layout, 8);
        MedicationViewerHelper.createMandantColumn(this.viewer, this.layout, 7);
        this.viewer.setContentProvider((IContentProvider)new MedicationTableViewerContentProvider((StructuredViewer)this.viewer));
    }

    public void setMedicationComposite(MedicationComposite medicationComposite) {
        this.medicationComposite = medicationComposite;
    }

    public TableViewer getTableViewer() {
        return this.viewer;
    }

    public void setInput(List<IPrescription> medicationInput) {
        if (this.isVisible()) {
            this.viewer.setInput(medicationInput);
        } else {
            this.pendingInput = medicationInput;
        }
    }

    public void setPendingInput() {
        if (this.pendingInput != null) {
            this.viewer.setInput(this.pendingInput);
            this.pendingInput = null;
        }
    }
}

