/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.laboratory.dialogs;

import ch.elexis.core.data.interfaces.ILabResult;
import ch.elexis.core.types.LabItemTyp;
import ch.elexis.core.ui.laboratory.dialogs.Messages;
import ch.elexis.core.ui.views.controls.LaborSelectionComposite;
import ch.elexis.data.LabResult;
import ch.rgw.tools.TimeTool;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DateTime;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class EditLabResultDialog
extends TitleAreaDialog {
    private Composite editComposite;
    private Text resultTxt;
    private Text unitTxt;
    private Text refMaleTxt;
    private Text refFemaleTxt;
    private LaborSelectionComposite originSelection;
    private DateTime observationDate;
    private DateTime analyseDate;
    private DateTime transmissionDate;
    private DateTime observationTime;
    private DateTime analyseTime;
    private DateTime transmissionTime;
    private LabResult result;

    public EditLabResultDialog(Shell parentShell, ILabResult act) {
        this(parentShell, LabResult.load((String)act.getId()));
    }

    public EditLabResultDialog(Shell parentShell, LabResult act) {
        super(parentShell);
        this.result = act;
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText(Messages.EditLabResultDialog_shellTitle);
        this.setTitle(Messages.EditLabResultDialog_title);
        this.setMessage(String.format(Messages.EditLabResultDialog_message, this.result.getItem().getLabel(), this.result.getPatient().getLabel()));
        this.editComposite = new Composite(parent, 0);
        this.editComposite.setLayoutData((Object)new GridData(4, 0x1000000, true, true));
        this.editComposite.setLayout((Layout)new GridLayout(2, false));
        Label lbl = new Label(this.editComposite, 0);
        lbl.setText(Messages.Core_Value);
        lbl.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 1, 1));
        if (this.result.getItem().getTyp() == LabItemTyp.TEXT) {
            this.resultTxt = new Text(this.editComposite, 2626);
            GridData data = new GridData(4, 0x1000000, true, false, 1, 1);
            data.heightHint = 100;
            this.resultTxt.setLayoutData((Object)data);
        } else {
            this.resultTxt = new Text(this.editComposite, 2048);
            this.resultTxt.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        }
        lbl = new Label(this.editComposite, 0);
        lbl.setText(Messages.Core_Unit);
        lbl.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 1, 1));
        this.unitTxt = new Text(this.editComposite, 2048);
        this.unitTxt.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.unitTxt.setTextLimit(80);
        lbl = new Label(this.editComposite, 0);
        lbl.setText(Messages.EditLabResultDialog_labelRefMale);
        lbl.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 1, 1));
        this.refMaleTxt = new Text(this.editComposite, 2048);
        this.refMaleTxt.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.refMaleTxt.setTextLimit(80);
        lbl = new Label(this.editComposite, 0);
        lbl.setText(Messages.EditLabResultDialog_labelRefFemale);
        lbl.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 1, 1));
        this.refFemaleTxt = new Text(this.editComposite, 2048);
        this.refFemaleTxt.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.refFemaleTxt.setTextLimit(80);
        lbl = new Label(this.editComposite, 0);
        lbl.setText(Messages.Core_Laboratory);
        lbl.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 1, 1));
        this.originSelection = new LaborSelectionComposite(this.editComposite, 0);
        this.originSelection.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        lbl = new Label(this.editComposite, 0);
        lbl.setText(Messages.Core_Time);
        lbl.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        Group grp = new Group(this.editComposite, 0);
        grp.setLayout((Layout)new GridLayout(3, false));
        grp.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        lbl = new Label((Composite)grp, 0);
        lbl.setText(Messages.EditLabResultDialog_labelObservation);
        lbl.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 1, 1));
        this.observationTime = new DateTime((Composite)grp, 128);
        this.observationTime.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.observationDate = new DateTime((Composite)grp, 32);
        this.observationDate.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        lbl = new Label((Composite)grp, 0);
        lbl.setText(Messages.EditLabResultDialog_labelTransmission);
        lbl.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 1, 1));
        this.transmissionTime = new DateTime((Composite)grp, 128);
        this.transmissionTime.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.transmissionDate = new DateTime((Composite)grp, 32);
        this.transmissionDate.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        lbl = new Label((Composite)grp, 0);
        lbl.setText(Messages.EditLabResultDialog_labelAnalyse);
        lbl.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 1, 1));
        this.analyseTime = new DateTime((Composite)grp, 128);
        this.analyseTime.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.analyseDate = new DateTime((Composite)grp, 32);
        this.analyseDate.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.updateModelToTarget();
        return this.editComposite;
    }

    private String getUnit() {
        String ret = this.result.getUnit();
        if (ret == null || ret.isEmpty()) {
            ret = this.result.getItem().getUnit();
        }
        return ret;
    }

    private String getRefMale() {
        String ret = this.result.getRefMale();
        if (ret == null || ret.isEmpty()) {
            ret = this.result.getItem().getReferenceMale();
        }
        return ret;
    }

    private String getRefFemale() {
        String ret = this.result.getRefFemale();
        if (ret == null || ret.isEmpty()) {
            ret = this.result.getItem().getReferenceFemale();
        }
        return ret;
    }

    private TimeTool getTransmissionDate() {
        TimeTool ret = this.result.getTransmissionTime();
        if (ret == null) {
            ret = this.result.getDateTime();
        }
        return ret;
    }

    private TimeTool getAnalyseDate() {
        TimeTool ret = this.result.getAnalyseTime();
        if (ret == null) {
            ret = this.result.getDateTime();
        }
        return ret;
    }

    private TimeTool getSampleDate() {
        TimeTool ret = this.result.getObservationTime();
        if (ret == null) {
            ret = this.result.getDateTime();
        }
        return ret;
    }

    private void updateDateTimeModelToTarget() {
        TimeTool date = this.getTransmissionDate();
        this.transmissionTime.setTime(date.get(11), date.get(12), date.get(13));
        this.transmissionDate.setDate(date.get(1), date.get(2), date.get(5));
        date = this.getSampleDate();
        this.observationTime.setTime(date.get(11), date.get(12), date.get(13));
        this.observationDate.setDate(date.get(1), date.get(2), date.get(5));
        date = this.getAnalyseDate();
        this.analyseTime.setTime(date.get(11), date.get(12), date.get(13));
        this.analyseDate.setDate(date.get(1), date.get(2), date.get(5));
    }

    private void updateDateTimeTargetToModel() {
        TimeTool date = new TimeTool();
        this.getTime(this.transmissionTime, date);
        this.getDate(this.transmissionDate, date);
        this.result.setTransmissionTime(date);
        this.getTime(this.observationTime, date);
        this.getDate(this.observationDate, date);
        this.result.setObservationTime(date);
        this.getTime(this.analyseTime, date);
        this.getDate(this.analyseDate, date);
        this.result.setAnalyseTime(date);
    }

    private void getTime(DateTime widget, TimeTool time) {
        time.set(11, widget.getHours());
        time.set(12, widget.getMinutes());
        time.set(13, widget.getSeconds());
    }

    private void getDate(DateTime widget, TimeTool date) {
        date.set(1, widget.getYear());
        date.set(2, widget.getMonth());
        date.set(5, widget.getDay());
    }

    private void updateModelToTarget() {
        if (this.result != null) {
            if (this.result.getItem().getTyp() == LabItemTyp.NUMERIC || this.result.getItem().getTyp() == LabItemTyp.ABSOLUTE) {
                this.resultTxt.setText(this.result.getResult());
                this.unitTxt.setText(this.getUnit());
                this.refMaleTxt.setText(this.getRefMale());
                this.refFemaleTxt.setText(this.getRefFemale());
            } else if (this.result.getItem().getTyp() == LabItemTyp.TEXT) {
                if (this.result.isLongText()) {
                    this.resultTxt.setText(this.result.getComment());
                } else {
                    this.resultTxt.setText(this.result.getResult());
                }
                this.unitTxt.setText(this.getUnit());
                this.unitTxt.setEnabled(false);
                this.refMaleTxt.setText(this.getRefMale());
                this.refMaleTxt.setEnabled(false);
                this.refFemaleTxt.setText(this.getRefFemale());
                this.refFemaleTxt.setEnabled(false);
            }
            this.updateDateTimeModelToTarget();
            this.originSelection.setKontakt(this.result.getOrigin());
        }
    }

    private void updateTargetToModel() {
        if (this.result != null) {
            if (this.result.getItem().getTyp() == LabItemTyp.NUMERIC || this.result.getItem().getTyp() == LabItemTyp.ABSOLUTE) {
                this.result.setResult(this.resultTxt.getText());
                this.result.setUnit(this.unitTxt.getText());
                this.result.setRefMale(this.refMaleTxt.getText());
                this.result.setRefFemale(this.refFemaleTxt.getText());
                this.updateDateTimeTargetToModel();
            } else if (this.result.getItem().getTyp() == LabItemTyp.TEXT) {
                if (this.result.isLongText()) {
                    this.result.setResult("text");
                    this.result.set("Kommentar", this.resultTxt.getText());
                } else if (this.resultTxt.getText().length() < 200) {
                    this.result.setResult(this.resultTxt.getText());
                } else {
                    this.result.setResult("text");
                    this.result.set("Kommentar", this.resultTxt.getText());
                }
                this.updateDateTimeTargetToModel();
            }
            this.result.setOrigin(this.originSelection.getKontakt());
        }
    }

    private boolean isValid() {
        if (this.resultTxt.getText().length() < 1) {
            this.setErrorMessage(Messages.EditLabResultDialog_errorNoResult);
            return false;
        }
        if (!this.resultTxt.getText().isEmpty() && this.result.getItem().getTyp() == LabItemTyp.NUMERIC) {
            try {
                String numeric = this.resultTxt.getText();
                if (numeric.startsWith("<") || numeric.startsWith(">")) {
                    numeric = numeric.substring(1, numeric.length());
                }
                Float.parseFloat(numeric);
            }
            catch (NumberFormatException e) {
                this.setErrorMessage(Messages.EditLabResultDialog_errorResultNotNumber);
                return false;
            }
        }
        if (!this.resultTxt.getText().isEmpty() && this.result.getItem().getTyp() == LabItemTyp.ABSOLUTE && !LabResult.isValidAbsoluteRefValue((String)this.resultTxt.getText())) {
            this.setErrorMessage(Messages.EditLabItemDialog_errorResultNotAbsolute);
            return false;
        }
        if (!this.refMaleTxt.getText().isEmpty()) {
            if (this.result.getItem().getTyp() == LabItemTyp.ABSOLUTE) {
                if (!LabResult.isValidAbsoluteRefValue((String)this.refMaleTxt.getText())) {
                    this.setErrorMessage(Messages.EditLabItemDialog_errorRefMaleNotAbsolute);
                    return false;
                }
            } else if (this.result.getItem().getTyp() != LabItemTyp.TEXT && !LabResult.isValidNumericRefValue((String)this.refMaleTxt.getText())) {
                this.setErrorMessage(Messages.EditLabResultDialog_errorRefMaleNotNumber);
                return false;
            }
        }
        if (!this.refFemaleTxt.getText().isEmpty()) {
            if (this.result.getItem().getTyp() == LabItemTyp.ABSOLUTE) {
                if (!LabResult.isValidAbsoluteRefValue((String)this.refFemaleTxt.getText())) {
                    this.setErrorMessage(Messages.EditLabItemDialog_errorRefFemaleNotAbsolute);
                    return false;
                }
            } else if (this.result.getItem().getTyp() != LabItemTyp.TEXT && !LabResult.isValidNumericRefValue((String)this.refFemaleTxt.getText())) {
                this.setErrorMessage(Messages.EditLabResultDialog_errorRefFemaleNotNumber);
                return false;
            }
        }
        return true;
    }

    protected void okPressed() {
        if (!this.isValid()) {
            return;
        }
        this.updateTargetToModel();
        super.okPressed();
    }
}

