/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.laboratory.controls.model;

import ch.elexis.data.LabItem;
import ch.elexis.data.LabResult;
import ch.rgw.tools.TimeTool;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

public class LaborItemResults
implements Comparable<LaborItemResults> {
    private HashMap<String, List<LabResult>> results;
    private String item;

    public LaborItemResults(String item, HashMap<String, List<LabResult>> results) {
        this.results = results;
        this.item = item;
        this.results.values().forEach(list -> Collections.sort(list, (l, r) -> TimeTool.compare((TimeTool)r.getObservationTime(), (TimeTool)l.getObservationTime())));
    }

    public LabItem getLabItem() {
        return (LabItem)this.getFirstResult().getItem();
    }

    public String getItem() {
        return this.item;
    }

    public boolean isVisible() {
        return this.results.values().iterator().next().get(0).getItem().isVisible();
    }

    public LabResult getFirstResult() {
        return this.results.values().iterator().next().get(0);
    }

    public List<LabResult> getResult(String date) {
        return this.results.get(date);
    }

    public List<String> getDays() {
        return new ArrayList<String>(this.results.keySet());
    }

    @Override
    public int compareTo(LaborItemResults o) {
        return this.item.compareTo(o.getItem());
    }

    public Collection<LabResult> getAllResults() {
        ArrayList<LabResult> allResults = new ArrayList<LabResult>();
        for (List<LabResult> resultList : this.results.values()) {
            allResults.addAll(resultList);
        }
        return allResults;
    }
}

